package com.liquidnet.service.bank.currencycloud.entity;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * currency cloud beneficiaries table
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class BankCcBeneficiary implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * Beneficiary name.
     */
    private String name;

    /**
     * Bank account holder's name.
     */
    private String bankAccountHolderName;

    /**
     * 	Two-letter code for the country in which the beneficiary's bank account is held.
     */
    private String bankCountry;

    /**
     * Currency in which money is held in the beneficiary's bank account. Three-digit currency code.
     */
    private String currency;

    private String email;

    private String beneficiaryCountry;

    private String beneficiaryAddress;

    private String accountNumber;

    @TableField(value = "routing_code_type_1")
    private String routingCodeType1;

    /**
     * Routing code for "routing_code_type_1".
     */
    @TableField(value = "routing_code_value_1")
    private String routingCodeValue1;

    @TableField(value = "routing_code_type_2")
    private String routingCodeType2;

    @TableField(value = "routing_code_value_2")
    private String routingCodeValue2;

    private String bicSwift;

    private String iban;

    /**
     * Payments are made automatically to default beneficiaries when a beneficiary is not specified.
     */
    private Boolean defaultBeneficiary;

    private String bankAddress;

    private String bankAccountType;

    private String bankName;

    private String beneficiaryEntityType;

    /**
     * Required if "beneficiary_entity_type" is "company".
     */
    private String beneficiaryCompanyName;

    /**
     * Required if "beneficiary_entity_type" is "individual".
     */
    private String beneficiaryFirstName;

    /**
     * Required if "beneficiary_entity_type" is "individual".
     */
    private String beneficiaryLastName;

    private String beneficiaryCity;

    private String beneficiaryPostcode;

    private String beneficiaryStateOrProvince;

    /**
     * If "beneficiary_entity_type" is "company", date of registration. If "beneficiary_entity_type" is "individual", date of birth. ISO 8601 format YYYY-MM-DD.
     */
    private String beneficiaryDateOfBirth;

    /**
     * A legal document that verifies the identity of the beneficiary. Required documentation will vary depending on the country in which the beneficiary's bank account is held.
     */
    private String beneficiaryIdentificationType;

    private String paymentTypes;

    @TableField("on_behalf_of")
    private String creatorContactId;

    private String beneficiaryExternalReference;

    private String ccAccountId;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;

}
