package com.liquidnet.service.merchant.service;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.merchant.constant.MerchantRedisConst;
import com.liquidnet.service.merchant.dto.vo.*;
import com.liquidnet.service.merchant.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Slf4j
@Service
public class MerchantRdmService {

    @Autowired
    RedisUtil redisUtil;

    @Autowired
    private MerchantMongoService merchantMongoService;

    // 【场地】获取详情
    public MerchantFieldsVo getFieldsVoByFieldId(String fieldId) {
        if (null == fieldId || fieldId.isEmpty()) {
            return null;
        }
        String key = MerchantRedisConst.INFO_FIELD.concat(fieldId);
        long s = System.currentTimeMillis();
        MerchantFieldsVo vo = (MerchantFieldsVo) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        if (null == vo) {
            vo = merchantMongoService.getFieldsVoByFieldId(fieldId);
            redisUtil.set(key, vo);
        }
        return vo;
    }

    // 【场地】更新详情
    public boolean setFieldsVoByFieldId(String fieldId, MerchantFieldsVo vo) {
        return redisUtil.set(MerchantRedisConst.INFO_FIELD.concat(fieldId), vo);
    }


    // 【场地申请】我的列表
    public List<MerchantFieldAppliesVo> getFieldAppliesVosByUid(String uid) {
        if (null == uid || uid.isEmpty()) {
            return null;
        }
        String key = MerchantRedisConst.INFO_FIELD_APPLIES.concat(uid);
        long s = System.currentTimeMillis();
        List<MerchantFieldAppliesVo> vos = (List<MerchantFieldAppliesVo>) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        if (null == vos) {
            vos = merchantMongoService.getFieldAppliesVosByUid(uid);
            redisUtil.set(key, vos);
        }
        return vos;
    }

    // 【场地申请】新增
    public boolean addFieldAppliesVoByUid(String uid, List<MerchantFieldAppliesVo> vos, MerchantFieldAppliesVo vo) {
        if (null == vos) {
            vos = ObjectUtil.getMerchantFieldAppliesVoArrayList();
        }
        vos.add(vo);
        return redisUtil.set(MerchantRedisConst.INFO_FIELD_APPLIES.concat(uid), vos);
    }

    // 【场地申请】删除
    public boolean delFieldAppliesVoByUid(String uid, List<MerchantFieldAppliesVo> vos, MerchantFieldAppliesVo vo) {
        if (CollectionUtils.isEmpty(vos)) {
            return true;
        }
        vos.removeIf(r -> r.getFieldApplyId().equals(vo.getFieldApplyId()));
        return redisUtil.set(MerchantRedisConst.INFO_FIELD_APPLIES.concat(uid), vos);
    }


    // 【场地默认验票员】列表
    public List<MerchantFieldCheckersVo> getFieldCheckersVosByFieldId(String fieldId) {
        String key = MerchantRedisConst.INFO_FIELD_CHECKERS.concat(fieldId);
        long s = System.currentTimeMillis();
        List<MerchantFieldCheckersVo> vos = (List<MerchantFieldCheckersVo>)redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        return vos;
    }

    // 【场地默认验票员】新增
    public boolean addFieldCheckersVoByFieldId(String fieldId, List<MerchantFieldCheckersVo> vos, MerchantFieldCheckersVo vo) {
        if (null == vos) {
            vos = ObjectUtil.getMerchantFieldCheckersVoArrayList();
        }
        vos.add(vo);
        return redisUtil.set(MerchantRedisConst.INFO_FIELD_CHECKERS.concat(fieldId), vos);
    }

    // 【场地默认验票员】删除
    public boolean delFieldCheckersVoByFieldId(String fieldId, List<MerchantFieldCheckersVo> vos,  MerchantFieldCheckersVo vo) {
        if (CollectionUtils.isEmpty(vos)) {
            return true;
        }
        vos.removeIf(r -> r.getFieldCheckerId().equals(vo.getFieldCheckerId()));
        return redisUtil.set(MerchantRedisConst.INFO_FIELD_CHECKERS.concat(fieldId), vos);
    }

    // 【主办】详情
    public MerchantSponsorsVo getSponsorsVoBySponsorId(String sponsorId) {
        if (null == sponsorId || sponsorId.isEmpty()) {
            return null;
        }
        String key = MerchantRedisConst.INFO_SPONSOR.concat(sponsorId);
        long s = System.currentTimeMillis();
        MerchantSponsorsVo vo = (MerchantSponsorsVo) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        if (null == vo) {
            vo = merchantMongoService.getSponsorsVoBySponsorId(sponsorId);
            redisUtil.set(key, vo);
        }
        return vo;
    }

    // 【主办】更新详情
    public boolean setSponsorsVoBySponsorId(String sponsorId, MerchantSponsorsVo vo) {
        return redisUtil.set(MerchantRedisConst.INFO_SPONSOR.concat(sponsorId), vo);
    }

    // 【主办申请】我的列表
    public List<MerchantSponsorAppliesVo> getSponsorAppliesVosByUid(String uid) {
        if (null == uid || uid.isEmpty()) {
            return null;
        }
        String key = MerchantRedisConst.INFO_SPONSOR_APPLIES.concat(uid);
        long s = System.currentTimeMillis();
        List<MerchantSponsorAppliesVo> vos = (List<MerchantSponsorAppliesVo>) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        if (null == vos) {
            vos = merchantMongoService.getSponsorAppliesVosByUid(uid);
            redisUtil.set(key, vos);
        }
        return vos;
    }

    // 【主办申请】新增
    public boolean addSponsorAppliesVoByUid(String uid, List<MerchantSponsorAppliesVo> vos, MerchantSponsorAppliesVo vo) {
        if (null == vos) {
            vos = ObjectUtil.getMerchantSponsorAppliesVoArrayList();
        }
        vos.add(vo);
        return redisUtil.set(MerchantRedisConst.INFO_SPONSOR_APPLIES.concat(uid), vos);
    }

    // 【主办申请】删除
    public boolean delSponsorAppliesVoByUid(String uid, List<MerchantSponsorAppliesVo> vos, MerchantSponsorAppliesVo vo) {
        if (CollectionUtils.isEmpty(vos)) {
            return true;
        }
        vos.removeIf(r -> r.getSponsorApplyId().equals(vo.getSponsorApplyId()));
        return redisUtil.set(MerchantRedisConst.INFO_SPONSOR_APPLIES.concat(uid), vos);
    }
}
