package com.liquidnet.service.kylin.service.partner;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.kylin.dao.PerformancePartnerListDao;
import com.liquidnet.service.kylin.dto.param.*;
import com.liquidnet.service.kylin.dto.vo.partner.PerformancePartnerVo;
import com.liquidnet.service.kylin.entity.KylinPerformances;

/**
 * <p>
 * 演出 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
public interface IKylinPerformancesPartnerService extends IService<KylinPerformances> {


    /**
     * 演出第一步
     * @param step1Param
     * @return
     */
    String step1(PerformanceStep1Param step1Param);
    /**
     * 创建演出第一步
     * @param step1Param
     * @return
     */
    String createStep1(PerformanceStep1Param step1Param);

    /**
     * 修改演出第一步
     * @param step1Param
     * @return
     */
    String updateStep1(PerformanceStep1Param step1Param);

    /**
     * 获取演出第一步数据
     * @param performancesId
     * @return
     */
    PerformancePartnerVo getStep1(String performancesId);

    /**
     * 获取创建演出第一步数据
     * @param performancesId
     * @return
     */
    PerformanceParam getCreateStep1(String performancesId);

    /**
     * 获取修改演出第一步数据
     * @param performancesId
     * @return
     */
    PerformanceParam getUpdateStep1(String performancesId);


    /**
     * 演出第二步
     * @param step2Param
     * @return
     */
    boolean step2(PerformanceStep2Param step2Param);

    /**
     * 演出第二步创建
     * @param step2Param
     * @return
     */
    boolean createStep2(PerformanceStep2Param step2Param);

    /**
     * 演出第二步修改
     * @param step2Param
     * @return
     */
    boolean updateStep2(PerformanceStep2Param step2Param);

    PerformanceStep2Param getStep2(String performancesId);

    PerformanceStep2Param getCreateStep2(String performancesId);

    PerformanceStep2Param getUpdateStep2(String performancesId);

    boolean onLinePerformance(String performancesId);

    boolean outLinePerformance(String performancesId);

    PageInfo<PerformancePartnerListDao> getList(PerformancePartnerListParam performancePartnerListParam);
}
