package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.service.kylin.dto.param.PerformanceCreateParam;
import com.liquidnet.service.kylin.dto.vo.PerformanceVo;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import com.liquidnet.service.kylin.mapper.KylinPerformancesMapper;
import com.liquidnet.service.kylin.service.IKylinPerformancesService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.mongodb.BasicDBObject;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

/**
 * <p>
 * 前端 演出 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-11
 */
@Service
public class KylinPerformancesServiceImpl extends ServiceImpl<KylinPerformancesMapper, KylinPerformances> implements IKylinPerformancesService {

    @Autowired
    private MongoTemplate mongoTemplate;

    public HashMap<String, Object> localList(String title, String cityId, Integer type, Integer page, Integer size, Integer SortType) {
        HashMap<String,Object> info = new HashMap<>();

        // 排序 分页
        Sort sortName = null; // 默认开票越早的在上面
        if (SortType != null) {
            switch (SortType) {
                case 1:
                    sortName = Sort.by(Sort.Direction.ASC, "sellTime");
                    break;
                case 2:
                    sortName = Sort.by(Sort.Direction.DESC, "sellTime");
                    break;
                default:
                    sortName = Sort.by(Sort.Direction.ASC, "sellTime");
                    break;
            }
        }
        Pageable pageable = PageRequest.of(page - 1, size, sortName);

        //条件
        Document queryObject = new Document();

        if (!title.isEmpty()) {
            queryObject.put("title", Pattern.compile(title, Pattern.CASE_INSENSITIVE));
        }
        if (!cityId.isEmpty()) {
            queryObject.put("cityId", cityId);
        }
        if (type != null) {
            queryObject.put("type", type);
        }

        // 固定查询条件
        Query query = new BasicQuery(queryObject);
        LocalDateTime nowTime = LocalDateTime.now();
        String nowTimeStr = nowTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        query.addCriteria(Criteria.where("stopSellTime").gte(nowTimeStr));
        query.addCriteria(Criteria.where("statusSell").is(1));

        // 要查询的字段
        /*Document fieldsObject = new Document();
        Query query = new BasicQuery(queryObject, fieldsObject);
        fieldsObject.put("performancesId", true);*/

        // 查询总数
        long count = mongoTemplate.count(query, PerformanceVo.class, PerformanceVo.class.getSimpleName());

        query.with(pageable);

        List<PerformanceVo> list = mongoTemplate.find(query, PerformanceVo.class, PerformanceVo.class.getSimpleName());

        // 组合数据
        info.put("total",count);
        info.put("data", list);

        return info;
    }

}
