package com.liquidnet.service.dragon.channel.unionpay.strategy;

import com.liquidnet.service.dragon.channel.unionpay.strategy.annotation.StrategyUnionpayHandler;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;


/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: Test
 * @Package com.liquidnet.service.dragon.channel.strategy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 14:27
 */
@Component
public class UnionpayStrategyListener implements ApplicationListener<ContextRefreshedEvent> {

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(StrategyUnionpayHandler.class);
        UnionpayStrategyContext strategyContext = event.getApplicationContext().getBean(UnionpayStrategyContext.class);
        beans.forEach((name, bean) -> {
            StrategyUnionpayHandler typeHandler = bean.getClass().getAnnotation(StrategyUnionpayHandler.class);
            strategyContext.putStrategy(typeHandler.value().getCode(), (IUnionpayStrategy) bean);
        });
    }
}