package com.liquidnet.service.reconciliation.constant;

public enum CurrencyCodeEnum {
    AED("1784","AED"),
    AFN("1971","AFN"),
    ALL("1008","ALL"),
    AMD("1051","AMD"),
    ANG("1532","ANG"),
    AOA("1973","AOA"),
    ARS("1032","ARS"),
    AUD("1036","AUD"),
    AWG("1533","AWG"),
    AZN("1944","AZN"),
    BAM("1977","BAM"),
    BBD("1052","BBD"),
    BDT("1050","BDT"),
    BGN("1975","BGN"),
    BHD("1048","BHD"),
    BIF("1108","BIF"),
    BMD("1060","BMD"),
    BND("1096","BND"),
    BOB("1068","BOB"),
    BOV("1984","BOV"),
    BRL("1986","BRL"),
    BSD("1044","BSD"),
    BTN("1064","BTN"),
    BWP("1072","BWP"),
    BYN("1933","BYN"),
    BZD("1084","BZD"),
    CAD("1124","CAD"),
    CDF("1976","CDF"),
    CHE("1947","CHE"),
    CHF("1756","CHF"),
    CHW("1948","CHW"),
    CLF("1990","CLF"),
    CLP("1152","CLP"),
    CNY("1156","CNY"),
    COP("1170","COP"),
    COU("1970","COU"),
    CRC("1188","CRC"),
    CUC("1931","CUC"),
    CUP("1192","CUP"),
    CVE("1132","CVE"),
    CZK("1203","CZK"),
    DJF("1262","DJF"),
    DKK("1208","DKK"),
    DOP("1214","DOP"),
    DZD("1012","DZD"),
    EGP("1818","EGP"),
    ERN("1232","ERN"),
    ETB("1230","ETB"),
    EUR("1978","EUR"),
    FJD("1242","FJD"),
    FKP("1238","FKP"),
    GBP("1826","GBP"),
    GEL("1981","GEL"),
    GHS("1936","GHS"),
    GIP("1292","GIP"),
    GMD("1270","GMD"),
    GNF("1324","GNF"),
    GTQ("1320","GTQ"),
    GYD("1328","GYD"),
    HKD("1344","HKD"),
    HNL("1340","HNL"),
    HRK("1191","HRK"),
    HTG("1332","HTG"),
    HUF("1348","HUF"),
    IDR("1360","IDR"),
    ILS("1376","ILS"),
    INR("1356","INR"),
    IQD("1368","IQD"),
    IRR("1364","IRR"),
    ISK("1352","ISK"),
    JMD("1388","JMD"),
    JOD("1400","JOD"),
    JPY("1392","JPY"),
    KES("1404","KES"),
    KGS("1417","KGS"),
    KHR("1116","KHR"),
    KMF("1174","KMF"),
    KPW("1408","KPW"),
    KRW("1410","KRW"),
    KWD("1414","KWD"),
    KYD("1136","KYD"),
    KZT("1398","KZT"),
    LAK("1418","LAK"),
    LBP("1422","LBP"),
    LKR("1144","LKR"),
    LRD("1430","LRD"),
    LSL("1426","LSL"),
    LYD("1434","LYD"),
    MAD("1504","MAD"),
    MDL("1498","MDL"),
    MGA("1969","MGA"),
    MKD("1807","MKD"),
    MMK("1104","MMK"),
    MNT("1496","MNT"),
    MOP("1446","MOP"),
    MRU("1929","MRU"),
    MUR("1480","MUR"),
    MVR("1462","MVR"),
    MWK("1454","MWK"),
    MXN("1484","MXN"),
    MXV("1979","MXV"),
    MYR("1458","MYR"),
    MZN("1943","MZN"),
    NAD("1516","NAD"),
    NGN("1566","NGN"),
    NIO("1558","NIO"),
    NOK("1578","NOK"),
    NPR("1524","NPR"),
    NZD("1554","NZD"),
    OMR("1512","OMR"),
    PAB("1590","PAB"),
    PEN("1604","PEN"),
    PGK("1598","PGK"),
    PHP("1608","PHP"),
    PKR("1586","PKR"),
    PLN("1985","PLN"),
    PYG("1600","PYG"),
    QAR("1634","QAR"),
    RON("1946","RON"),
    RSD("1941","RSD"),
    RUB("1643","RUB"),
    RWF("1646","RWF"),
    SAR("1682","SAR"),
    SBD("1090","SBD"),
    SCR("1690","SCR"),
    SDG("1938","SDG"),
    SEK("1752","SEK"),
    SGD("1702","SGD"),
    SHP("1654","SHP"),
    SLL("1694","SLL"),
    SOS("1706","SOS"),
    SRD("1968","SRD"),
    SSP("1728","SSP"),
    STN("1930","STN"),
    SVC("1222","SVC"),
    SYP("1760","SYP"),
    SZL("1748","SZL"),
    THB("1764","THB"),
    TJS("1972","TJS"),
    TMT("1934","TMT"),
    TND("1788","TND"),
    TOP("1776","TOP"),
    TRY("1949","TRY"),
    TTD("1780","TTD"),
    TWD("1901","TWD"),
    TZS("1834","TZS"),
    UAH("1980","UAH"),
    UGX("1800","UGX"),
    USD("1840","USD"),
    USN("1997","USN"),
    UYI("1940","UYI"),
    UYU("1858","UYU"),
    UYW("1927","UYW"),
    UZS("1860","UZS"),
    VES("1928","VES"),
    VND("1704","VND"),
    VUV("1548","VUV"),
    WST("1882","WST"),
    XAF("1950","XAF"),
    XCD("1951","XCD"),
    XOF("1952","XOF"),
    XPF("1953","XPF"),
    YER("1886","YER"),
    ZAR("1710","ZAR"),
    ZMW("1967","ZMW"),
    ZWL("1932","ZWL");
    private String code;
    private String desc;
    CurrencyCodeEnum(String code,String desc){
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getDescByCode(String code){
        CurrencyCodeEnum[] arry = CurrencyCodeEnum.values();
        for (int i = 0; i < arry.length; i++) {
            if (arry[i].getCode().equalsIgnoreCase(code)) {
                return arry[i].desc;
            }
        }
        return null;
    }
}
