package com.liquidnet.service.sweet.vo;

import com.liquidnet.service.sweet.entity.SweetAnswer;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class SweetAnswerVo implements Serializable, Cloneable {
    /**
     * 手机号
     */
    private String phone;

    /**
     * 答案json
     */
    private String answerJson;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetAnswerVo obj = new SweetAnswerVo();
    public static SweetAnswerVo getNew() {
        try {
            return (SweetAnswerVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetAnswerVo();
        }
    }

    public SweetAnswerVo copy(SweetAnswer source) {
        if (null == source) return this;
        this.setPhone(source.getPhone());
        this.setAnswerJson(source.getAnswerJson());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }

}
