package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 城市投票统计表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-09-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetCityVoteStat implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * stat_id
     */
    private String statId;

    /**
     * 城市代码
     */
    private String cityCode;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 真实投票数量
     */
    private Integer voteNum;

    /**
     * 手动增加投票数量
     */
    private Integer manualVoteNum;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
