package com.liquidnet.service.chime.controller;

import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 演出相关
 * @class: ChimePerformanceController
 * @Package com.liquidnet.service.chime.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/6 11:43
 */
@Api(tags = "在场-演出列表")
@RestController
@RequestMapping("performance")
@Validated
public class ChimePerformanceController {
    @GetMapping("myList")
    @ApiOperation("已购票的演出")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "cityName", value = "城市名称", required = true),
            @ApiImplicitParam(type = "query", dataType = "int", name = "days", value = "时间范围 几天 今天1 三天3。。。"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "type", value = "演出类型 101音乐节 102小型演出(livehouse演出) 103巡演 演出类型只有这几个了"),

            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isDiscount", value = "是否会员优惠 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isAdvance", value = "是否优先 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isExclusive", value = "是否会员专属 0 1"),

            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间timeStart"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<HashMap<String, Object>> myList(
            @RequestParam(defaultValue = "") String cityName,
            @RequestParam(defaultValue = "0") int days,
            @RequestParam(defaultValue = "0") int type,

            @RequestParam(defaultValue = "") Integer isDiscount,
            @RequestParam(defaultValue = "") Integer isAdvance,
            @RequestParam(defaultValue = "") Integer isExclusive,

            // 排序
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {
//        HashMap<String, Object> result = kylinPerformancesService.localList(
//                days, cityName, type,
//                isDiscount, isAdvance, isExclusive,
//                orderBy, sort
//        );
//        return ResponseDto.success(result);
        return null;
    }

    @GetMapping("localList")
    @ApiOperation("本地最近演出列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "cityName", value = "城市名称", required = true),
            @ApiImplicitParam(type = "query", dataType = "int", name = "days", value = "时间范围 几天 今天1 三天3。。。"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "type", value = "演出类型 101音乐节 102小型演出(livehouse演出) 103巡演 演出类型只有这几个了"),

            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isDiscount", value = "是否会员优惠 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isAdvance", value = "是否优先 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isExclusive", value = "是否会员专属 0 1"),

            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间timeStart"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<HashMap<String, Object>> localList(
            @RequestParam(defaultValue = "") String cityName,
            @RequestParam(defaultValue = "0") int days,
            @RequestParam(defaultValue = "0") int type,

            @RequestParam(defaultValue = "") Integer isDiscount,
            @RequestParam(defaultValue = "") Integer isAdvance,
            @RequestParam(defaultValue = "") Integer isExclusive,

            // 排序
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {
//        HashMap<String, Object> result = kylinPerformancesService.localList(
//                days, cityName, type,
//                isDiscount, isAdvance, isExclusive,
//                orderBy, sort
//        );
//        return ResponseDto.success(result);
        return null;
    }

    @GetMapping("getUserListByCon")
    @ApiOperation("查询用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "cityName", value = "城市名称", required = true),
            @ApiImplicitParam(type = "query", dataType = "int", name = "days", value = "时间范围 几天 今天1 三天3。。。"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "type", value = "演出类型 101音乐节 102小型演出(livehouse演出) 103巡演 演出类型只有这几个了"),

            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isDiscount", value = "是否会员优惠 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isAdvance", value = "是否优先 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isExclusive", value = "是否会员专属 0 1"),

            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间timeStart"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<HashMap<String, Object>> getUserListByCon(
            @RequestParam(defaultValue = "") String cityName,
            @RequestParam(defaultValue = "0") int days,
            @RequestParam(defaultValue = "0") int type,

            @RequestParam(defaultValue = "") Integer isDiscount,
            @RequestParam(defaultValue = "") Integer isAdvance,
            @RequestParam(defaultValue = "") Integer isExclusive,

            // 排序
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {
//        HashMap<String, Object> result = kylinPerformancesService.localList(
//                days, cityName, type,
//                isDiscount, isAdvance, isExclusive,
//                orderBy, sort
//        );
//        return ResponseDto.success(result);
        return null;
    }

}
