package com.liquidnet.service.kylin.dao;

import lombok.Data;

@Data
public class PerformanceRecommendAdminDao {

    private String performancesId;
    private String title;
    private String timeStart;
    private Integer status;
    private String statusName;
    private Integer isRecommend;

    public void setStatus(Integer status){
        this.status=status;
        switch (status){
            case 1:
                this.statusName="审核中";
                break;
            case 3:
                this.statusName="审核通过";
                break;
            case 4:
                this.statusName="审核拒绝";
                break;
            case 6:
                this.statusName="售卖中";
                break;
            case 7:
                this.statusName="已下架";
                break;
            case 8:
                this.statusName="售罄";
                break;
            case 9:
                this.statusName="演出结束";
                break;
            case 10:
                this.statusName="演出未开始";
                break;
            default:
                this.statusName="其他";
                break;
        }
    }
}
