package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.param.SweetAntigenicQuestionParam;
import com.liquidnet.service.sweet.service.ISweetAntigenicQuestionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * <p>
 * 防疫答题表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-09-28
 */
@Api(tags = "活动-防疫答题")
@RestController
@RequestMapping("/AntigenicQuestion")
public class SweetAntigenicQuestionController {

    @Autowired
    private ISweetAntigenicQuestionService sweetAntigenicQuestionService;

    @PostMapping("create")
    @ApiOperation("添加答题记录")
    public ResponseDto<Boolean> add(@Valid @RequestBody SweetAntigenicQuestionParam param) {
        return sweetAntigenicQuestionService.create(param);
    }

}
