package com.liquidnet.service.platform.controller.candy.task;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.candy.constant.CandyRedisConst;
import com.liquidnet.service.candy.dto.CandyCouponCodeDto;
import com.liquidnet.service.candy.dto.CandyCouponInfoDto;
import com.liquidnet.service.candy.dto.CandyCouponRuleDto;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;
import com.liquidnet.service.candy.entity.*;
import com.liquidnet.service.platform.service.impl.adam.dm.DMRdmService;
import com.liquidnet.service.platform.service.impl.candy.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("candy/task")
public class CandyMgtCouponTaskController {
    @Autowired
    private PlatformCandyMgtCouponService platformCandyMgtCouponService;
    @Autowired
    private PlatformCandyCouponService platformCandyCouponService;

    @PostMapping("issue/coupons")
    public void issueCoupons() {
        LambdaQueryWrapper<CandyMgtCoupon> queryWrapper = Wrappers.lambdaQuery(CandyMgtCoupon.class)
                .eq(CandyMgtCoupon::getState, 0)
                // TODO: 2021/8/26 时间判断
                .orderByAsc(CandyMgtCoupon::getEventAt);
        List<CandyMgtCoupon> list = platformCandyMgtCouponService.list(queryWrapper);
        int taskSize = CollectionUtils.isEmpty(list) ? -1 : list.size();
        log.info("发放券任务总数:{} >>> BEGIN BEGIN BEGIN", taskSize);

        LambdaQueryWrapper<CandyCoupon> couponQueryWrapper = Wrappers.lambdaQuery(CandyCoupon.class).eq(CandyCoupon::getState, 1);
        for (int i = 0; i < taskSize; i++) {
            CandyMgtCoupon mgtCoupon = list.get(i);
            mgtCoupon.setState(9);

            try {
                if (platformCandyMgtCouponService.updateById(mgtCoupon)) {
                    CandyCoupon coupon = platformCandyCouponService.getOne(couponQueryWrapper.eq(CandyCoupon::getCouponId, mgtCoupon.getCouponId()));

                    log.info("发放券任务总数:{},任务{}开始处理[mcouponId:{},couType:{},bindType:{},eventAmt:{},eventType:{}]", taskSize, i,
                            mgtCoupon.getMcouponId(), coupon.getCouType(), coupon.getBindType(), mgtCoupon.getEventAmt(), mgtCoupon.getEventType());

                    switch (coupon.getCouType()) {
                        case 1:// 代金券
                            platformCandyCouponService.issueCashCouponHandler(mgtCoupon, coupon);
                            break;
                        case 2:// 满减券
                            platformCandyCouponService.issueOverMinusCouponHandler(mgtCoupon, coupon);
                            break;
                        case 3:// 兑换券
                            platformCandyCouponService.issueExchangeCouponHandler(mgtCoupon, coupon);
                            break;
                        case 4:// 折扣券
                            platformCandyCouponService.issueDiscountCouponHandler(mgtCoupon, coupon);
                            break;
                        default:
                            log.warn("发放券任务总数:{},任务{}无法处理，无效的券类型[mcouponId:{},couType:{}]", taskSize, i, mgtCoupon.getMcouponId(), coupon.getCouType());
                            break;
                    }

                    mgtCoupon.setState(1);
                    boolean update = platformCandyMgtCouponService.updateById(mgtCoupon);

                    log.info("发放券任务总数:{},任务{}处理{}[mcouponId:{},couType:{},bindType:{},eventAmt:{},eventType:{}]", taskSize, i, (update ? "成功" : "失败"),
                            mgtCoupon.getMcouponId(), coupon.getCouType(), coupon.getBindType(), mgtCoupon.getEventAmt(), mgtCoupon.getEventType());
                }
            } catch (Exception e) {
                log.error("发放券任务总数:{},任务{}处理异常[mcouponId:{}]", taskSize, i, mgtCoupon.getMcouponId(), e);
            }
        }
        log.info("发放券任务总数:{} >>> END END END", taskSize);
    }
}
