package com.liquidnet.client.admin.web.controller.zhengzai.sweet;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetIntegralActivityPrizeRelationService;
import com.liquidnet.service.sweet.dto.SweetIntegralActivityDto;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityFromParam;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityListSearchParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * <p>
 * 积分活动表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */
@Api(tags = "积分活动管理")
@Validated
@Controller
@RequestMapping("/sweet/integralActivityPrizeRelation")
public class SweetIntegralActivityPrizeRelationController extends BaseController {
    private String prefix = "zhengzai/sweet/integralActivity";

    @Autowired
    private ISweetIntegralActivityPrizeRelationService activityPrizeRelationService;

    @Log(title = "积分活动创建", businessType = BusinessType.INSERT)
    @RequiresPermissions("sweet:integralActivity:create")
    @PostMapping("create")
    @ApiOperation(value = "积分活动创建")
    @ResponseBody
    public AjaxResult create(@Valid @RequestBody SweetIntegralActivityFromParam param) {
        Integer result = activityPrizeRelationService.createForm(param);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    @Log(title = "积分活动编辑", businessType = BusinessType.UPDATE)
    @RequiresPermissions("sweet:integralActivity:update")
    @PutMapping("update")
    @ApiOperation(value = "积分活动编辑")
    @ResponseBody
    public AjaxResult update(@Valid @RequestBody SweetIntegralActivityFromParam param) {
        Integer result = activityPrizeRelationService.updateForm(param);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    @Log(title = "积分活动列表数据", businessType = BusinessType.LIST)
    @RequiresPermissions("sweet:integralActivity:list")
    @ApiOperation(value = "积分活动列表数据")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(SweetIntegralActivityListSearchParam listParam) {
        PageInfo<SweetIntegralActivityDto> result = activityPrizeRelationService.list(listParam);
        return getDataTable(result.getList());
    }

}
