package com.liquidnet.service.sweet.handler;

import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * <p>
 * 文本消息
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-25
 */
@Component
@Slf4j
public class TextMsgHandler implements WxMpMessageHandler {

    @Autowired
    private WechatUsersRedisUtils redisUtils;

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService,
                                    WxSessionManager sessionManager) throws WxErrorException {
        boolean IsPosterClick = redisUtils.getStrawberryPosterClick(wxMessage.getFromUser());
        // TODO: 2021/11/25 线上改成正规模版消息
        if (IsPosterClick) {
            return WxMpXmlOutMessage.TEXT().content("您已参与活动，结果为:".concat(wxMessage.getContent()))
                    .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                    .build();
        } else {
            // TODO: 2021/11/25 正常应该是过滤掉 不处理 return null
            return WxMpXmlOutMessage.TEXT().content("您未参与活动或者超过10分钟回复期限，结果为:".concat(wxMessage.getContent()))
                    .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                    .build();
        }
    }
}
