package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册表
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetManual implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * manual_id
     */
    private String manualId;

    /**
     * 演出id
     */
    private String performanceId;

    /**
     * 0关闭 1开启
     */
    private Integer status;

    /**
     * 0取消 1发布
     */
    private Integer isRelease;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetManual obj = new SweetManual();
    public static SweetManual getNew() {
        try {
            return (SweetManual) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManual();
        }
    }
}
