package com.liquidnet.service.kylin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 订单退款表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderRefunds implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * order_refunds_id
     */
    private String orderRefundsId;

    /**
     * 票务订单id
     */
    private String orderTicketsId;

    /**
     * 退款编号
     */
    private String orderRefundCode;

    /**
     * 批量退款id
     */
    private String orderRefundBatchesId;

    /**
     * 退款中心退款编号
     */
    private String refundCode;

    /**
     * 成功退款时间
     */
    private String refundAt;

    /**
     * 第三方退款编号
     */
    private String refundId;

    /**
     * 退款失败原因
     */
    private String refundError;

    /**
     * 退款总金额
     */
    private BigDecimal price;
    private BigDecimal priceExpress;
    private BigDecimal priceCharges;

    /**
     * 退款状态: 0请求退款 2取消退款 1审核通过 5驳回退款 7等待退款 3正在退款 4完成退款 6退款失败
     */
    private Integer status;

    /**
     * 退款差异: 0申请退款返还库存 1自动退款无法取消退款不返还库存
     */
    private Integer type;

    /**
     * 申请人id
     */
    private String applicantId;

    /**
     * 申请人名称
     */
    private String applicantName;

    /**
     * 申请时间
     */
    private LocalDateTime applicantAt;

    /**
     * 退款原因
     */
    private String reason;

    /**
     * 审核人id
     */
    private String auditorId;

    /**
     * 审核人名称
     */
    private String auditorName;

    /**
     * 审核时间
     */
    private LocalDateTime auditorAt;

    /**
     * 驳回原因
     */
    private String reject;

    /**
     * 执行人id
     */
    private String executorId;

    /**
     * 执行人名称
     */
    private String executorName;

    /**
     * 执行时间
     */
    private LocalDateTime executorAt;

    /**
     * 回绝原因
     */
    private String refuse;

    /**
     * 票务审核人id
     */
    private String ticketAuditId;

    /**
     * 票务审核人名称
     */
    private String ticketAuditName;

    /**
     * 票务审核时间
     */
    private LocalDateTime ticketAuditAt;

    /**
     * 票务审核备注
     */
    private String ticketAuditRemark;

    /**
     * 票务/快递费/票和快递费
     */
    private String refundType;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private static final KylinOrderRefunds obj = new KylinOrderRefunds();
    public static KylinOrderRefunds getNew() {
        try {
            return (KylinOrderRefunds) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderRefunds();
        }
    }
}
