package com.liquidnet.service.goblin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.*;

import java.util.List;

public interface IGoblinAppZhengzaiService {

    /**
     * 正在下单活动列表
     *
     * @return
     */
    List<GoblinSelfMarketingVo> getZhengzaiMarketList();

    /**
     * 正在下单店铺列表
     *
     * @param marketId
     * @return
     */
    List<GoblinShowStoreInfoVo> getStoreList(String marketId);


    /**
     * 正在下单 商铺参与活动的商品列表
     * @param marketId
     * @param storeId
     * @return
     */
    List<GoblinZhengzaiGoodVo> getSpuList(String marketId,String storeId);


    /**
     * 正在下单出货
     * @param offCode 出货码
     * @return
     */
    ResponseDto<Boolean> orderPush(String offCode,String marketId);

    /**
     * 正在下单出货详情
     * @param offCode 出货码
     * @return
     */
    ResponseDto<List<GoblinZhengzaiPushVo>> orderPushDetails(String offCode,String marketId);

    ResponseDto<GoblinAppOrderDetailsVo> orderPushDetailsPos(String offCode, String marketId);

    /**
     * 订单绑定
     * @param uid
     * @param masterCode
     * @return
     */
    ResponseDto<Boolean> orderBind(String uid,String masterCode);
}
