package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistList2Dto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistStageListDto;
import com.liquidnet.service.sweet.entity.SweetArtists;
import com.liquidnet.service.sweet.entity.SweetManualArtists;
import com.liquidnet.service.sweet.entity.SweetStage;
import com.liquidnet.service.sweet.mapper.SweetArtistsMapper;
import com.liquidnet.service.sweet.mapper.SweetManualArtistsMapper;
import com.liquidnet.service.sweet.mapper.SweetStageMapper;
import com.liquidnet.service.sweet.service.ISweetArtistsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 艺人表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Service
public class SweetArtistsServiceImpl extends ServiceImpl<SweetArtistsMapper, SweetArtists> implements ISweetArtistsService {

    @Autowired
    private SweetArtistsMapper sweetArtistsMapper;
    @Autowired
    private SweetManualArtistsMapper sweetManualArtistsMapper;
    @Autowired
    private RedisDataUtils redisDataUtils;

    @Override
    public ResponseDto<PageInfo<SweetArtists>> getList(int page, int size, String name) {
        PageInfo<SweetArtists> pageInfo = null;
        try {
            PageHelper.startPage(page, size);
            List<SweetArtists> data = sweetArtistsMapper.selectList(Wrappers.lambdaQuery(SweetArtists.class).like(SweetArtists::getName, name));
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<Boolean> add(String picUrl, String name, String pinyin, String describe) {
        try {
            SweetArtists sweetArtists = new SweetArtists();
            sweetArtists.setArtistsId(IDGenerator.nextSnowId());
            sweetArtists.setPicUrl(picUrl);
            sweetArtists.setName(name);
            sweetArtists.setPinyin(pinyin);
            sweetArtists.setDescribes(describe);
            sweetArtists.setCreatedAt(LocalDateTime.now());
            sweetArtistsMapper.insert(sweetArtists);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetArtists> detail(String artistsId) {
        try {
            return ResponseDto.success(sweetArtistsMapper.selectOne(Wrappers.lambdaQuery(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String artistsId, String picUrl, String name, String pinyin, String describe) {
        try {
            SweetArtists sweetArtists = new SweetArtists();
            sweetArtists.setPicUrl(picUrl);
            sweetArtists.setName(name);
            sweetArtists.setPinyin(pinyin);
            sweetArtists.setDescribes(describe);
            sweetArtists.setUpdatdAt(LocalDateTime.now());
            sweetArtistsMapper.update(sweetArtists, Wrappers.lambdaUpdate(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId));

            List<SweetManualArtists> data = sweetManualArtistsMapper.selectList(Wrappers.lambdaQuery(SweetManualArtists.class).eq(SweetManualArtists::getArtistsId, artistsId));
            for (SweetManualArtists item : data) {
                redisDataUtils.deleteTimeListRedisData(item.getManualId());
            }
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }
}
