package com.liquidnet.service.smile.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SmileAgent implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 演出id
     */
    private String performanceId;

    /**
     * 票id
     */
    private String ticketId;


    /**
     * 总代票提
     */
    private BigDecimal totalCarry;

    /**
     * 普代票提
     */
    private BigDecimal ordCarry;

    /**
     * 删除标识 0未删除1已删除
     */
    private Integer delTag;

    public BigDecimal getTotalCarry() {
        return totalCarry!=null?totalCarry: BigDecimal.valueOf(0);
    }

    public BigDecimal getOrdCarry() {
        return ordCarry!=null?ordCarry: BigDecimal.valueOf(0);
    }
}
