package com.liquidnet.client.admin.zhengzai.goblin.service.imp;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontBannerService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontBanner;
import com.liquidnet.service.goblin.mapper.GoblinFrontBannerMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Service
public class GoblinFrontBannerServiceImpl extends ServiceImpl<GoblinFrontBannerMapper, GoblinFrontBanner> implements IGoblinFrontBannerService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinFrontBannerMapper goblinFrontBannerMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    public boolean create(GoblinFrontBanner goblinFrontBanner){
        goblinFrontBanner.setCreateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontBanner.setBannerId(GoblinRedisConst.FRONT_BANNER+ IDGenerator.nextTimeId());
        //增加 banner
        goblinFrontBannerMapper.insert(goblinFrontBanner);
     /*   //mongo  db增加
        mongoTemplate.save(goblinFrontBanner,GoblinFrontBanner.class.getSimpleName());
        //redis 增加
        LambdaQueryWrapper<GoblinFrontBanner> queryWrapper = Wrappers.lambdaQuery(GoblinFrontBanner.class);
        queryWrapper.ne(GoblinFrontBanner::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontBanner::getIndexs);
        List<GoblinFrontBanner> list=goblinFrontBannerMapper.selectList(queryWrapper);
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_BANNER,list);*/
        return true;
    }
    /***
     * @author zhangfuxin
     * @Description: 修改
     * @date 2021/12/27 下午4:03
     */
    public boolean update(GoblinFrontBanner goblinFrontBanner){
        goblinFrontBanner.setUpdateTime(LocalDateTime.now());
        //数据库修改
        goblinFrontBannerMapper.updateById(goblinFrontBanner);
       /* //mongodb修改
        BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontBanner)));
        mongoTemplate.getCollection(GoblinFrontBanner.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("bannerId").is(goblinFrontBanner.getBannerId())).getQueryObject(),
                orderObject
        );
        //redis 修改
        //从数据库中查出来，从新塞进去
        LambdaQueryWrapper<GoblinFrontBanner> queryWrapper = Wrappers.lambdaQuery(GoblinFrontBanner.class);
        queryWrapper.ne(GoblinFrontBanner::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontBanner::getIndexs);
        List<GoblinFrontBanner> list=goblinFrontBannerMapper.selectList(queryWrapper);
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_BANNER,list);*/
        return true;
    }
    /**
     * @author zhangfuxin
     * @Description:查看详情
     * @date 2021/12/27 下午4:34
     */
    public GoblinFrontBanner getOne(Long id){
        return  goblinFrontBannerMapper.selectById(id);
    }
    /**
     * @author zhangfuxin
     * @Description:  删除 banner
     * @date 2021/12/27 下午4:36
     */
    public boolean delte(Long id){
        GoblinFrontBanner goblinFrontBanner=goblinFrontBannerMapper.selectById(id);
        goblinFrontBanner.setDelTag(1);
        this.update(goblinFrontBanner);
        return true;
    }
    /**
     * @author zhangfuxin
     * @Description:分页
     * @date 2021/12/27 下午5:19
     */
    public PageInfo<GoblinFrontBanner> bannerPage(int pageSize,int pageNumber,GoblinFrontBanner goblinFrontBanner) {
        PageInfo<GoblinFrontBanner> pageInfoTmp = null;
        try {
            PageHelper.startPage(pageNumber, pageSize);
            LambdaQueryWrapper<GoblinFrontBanner> queryWrapper = Wrappers.lambdaQuery(GoblinFrontBanner.class);
            queryWrapper.orderByDesc(GoblinFrontBanner::getCreateTime);
            List<GoblinFrontBanner> list=goblinFrontBannerMapper.selectList(queryWrapper);
            pageInfoTmp = new PageInfo(list);
        } catch (Exception e) {
            return new PageInfo();
        }
        return pageInfoTmp;
    }


}
