package com.liquidnet.service.platform.controller.partner;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.CreateTicketTimesParam;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.kylin.service.partner.IKylinTicketTimesPartnerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * <p>
 * 场次 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Api(tags = "第三方-场次",position = 1002)
@RestController
@RequestMapping("partner/times")
@Validated
public class KylinTicketTimesPartnerController {

    @Autowired
    private IKylinTicketTimesPartnerService ticketTimesPartnerService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建场次",position = 1)
    @ApiResponse(response = KylinTicketTimesPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<KylinTicketTimesPartnerVo> createTimesSummary(@RequestBody @Valid CreateTicketTimesParam createTicketTimesParam) {
        return ticketTimesPartnerService.createTimesSummary(createTicketTimesParam);
    }

    @DeleteMapping(value = "")
    @ApiOperation(value = "删除场次",position = 2)
    @ApiResponse(response = KylinTicketTimesPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<String> deleteTimes(@RequestParam("ticketTimesId") @NotNull(message = "场次ID不能为空") String ticketTimesId,
                                           @RequestParam("performanceId") @NotNull(message = "演出ID不能为空") String performanceId) {
        return ticketTimesPartnerService.deleteTimes(ticketTimesId,performanceId);
    }

    @PutMapping(value = "")
    @ApiOperation(value = "修改场次",position = 3)
    @ApiResponse(response = KylinTicketTimesPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<KylinTicketTimesPartnerVo> changeTimes(@RequestBody @Valid CreateTicketTimesParam createTicketTimesParam) {
        return ticketTimesPartnerService.changeTimes(createTicketTimesParam);
    }

    @GetMapping(value = "/details")
    @ApiOperation(value = "获取场次详情",position = 4)
    @ApiResponse(response = KylinTicketTimesPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<KylinTicketTimesPartnerVo> getTimesMongo(@RequestParam("ticketTimesId") @NotNull(message = "场次ID不能为空") String ticketTimesId) {
        KylinTicketTimesPartnerVo result = null;
        result = ticketTimesPartnerService.getTimesMongo(ticketTimesId);
        if (null == result) {
            return ResponseDto.failure("查询场次信息失败");
        } else {
            return ResponseDto.success(result);
        }
    }


}
