package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * <p>
 * banner返回给前端的数据字段
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-03 11:19 上午
 */

@Data
@ApiModel
public class KylinTimePerformanceVo implements Serializable, Cloneable {
    @ApiModelProperty(value = "演出Id")
    private String performanceId;

    @ApiModelProperty(value = "定时上下线时间")
    private String time;

    @ApiModelProperty(value = "任务类型 [0|无状态|1-上线|2下线]")
    private Integer taskType;

    private static final KylinTimePerformanceVo obj = new KylinTimePerformanceVo();
    public static KylinTimePerformanceVo getNew() {
        try {
            return (KylinTimePerformanceVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinTimePerformanceVo();
        }
    }
}
