package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 会员信息
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamMember implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * 会员卡id
     */
    private String memberId;

    /**
     * 会员卡名称
     */
    private String name;

    /**
     * 标题
     */
    private String title;

    /**
     * 副标题
     */
    private String subTitle;

    /**
     * 图标
     */
    private String icon;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 起始编号
     */
    private Integer startNo;

    /**
     * 会员类型 1 - VIP会员
     */
    private Integer type;

    /**
     * 权益详情
     */
    private String interestsDetail;

    /**
     * 注意事项
     */
    private String notes;

    /**
     * '是否展示须知'
     */
    private Integer isNotice;

    /**
     * 须知内容
     */
    private String noticeInfo;

    /**
     * 须知标题
     */
    private String noticeTitle;

    /**
     * 是否需要答题 0不需要 1需要
     */
    private Integer needQuestion;

    /**
     * 是否展示协议 0否1是
     */
    private Integer displayAgreement;

    /**
     * 状态:1-NORMAL,2-INVALID
     */
    private Integer state;

    /**
     * 限购数量
     */
    private Integer limitation;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;
}
