package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinStoreMgtGoodsSkuArListVo", description = "商品管理:藏品AR列表信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinStoreMgtGoodsSkuArListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -6629148859241936997L;
    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(position = 12, value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 13, value = "单品AR文件URL-iOS版[256]")
    private String arUrlIos;
    @ApiModelProperty(position = 14, value = "单品AR文件URL-android版[256]")
    private String arUrlAndroid;

    private static final GoblinStoreMgtGoodsSkuArListVo obj = new GoblinStoreMgtGoodsSkuArListVo();

    public static GoblinStoreMgtGoodsSkuArListVo getNew() {
        try {
            return (GoblinStoreMgtGoodsSkuArListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMgtGoodsSkuArListVo();
        }
    }
}
