package com.liquidnet.service.consumer.adam.service.receiver;

import com.liquidnet.common.sms.processor.SmsProcessor;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SmsMessage;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.consumer.adam.service.IBaseDao;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamListener;

import javax.annotation.Resource;

@Slf4j
public abstract class AbstractSmsRedisReceiver implements StreamListener<String, MapRecord<String, String, String>> {
    @Resource
    SmsProcessor smsProcessor;
    @Autowired
    StringRedisTemplate stringRedisTemplate;


    @Override
    public void onMessage(MapRecord<String, String, String> message) {
        log.info("CONSUMER SMS[streamKey:{},messageId:{},stream:{},body:{}]",
                this.getRedisStreamKey(), message.getId(), message.getStream(), message.getValue());

        boolean result = this.consumerSmsSendHandler(message.getValue().get("message"));

        log.debug("CONSUMER SMS RESULT:{}", result);

        // 消费成功确认，消息删除和消息确认是一个事务
        if (result) {
            log.info("CONSUMER SMS SUCC ==> MESSAGE_ID:{}", message.getId());
            try {
                stringRedisTemplate.opsForStream().delete(this.getRedisStreamKey(), message.getId());
            } catch (Exception e) {
                log.error("CONSUMER SMS SUC ==> DEL_REDIS_QUEUE_MSG_EXCEPTION[MESSAGE_ID:{}]", message.getId(), e);
            }
        }
    }

    private boolean consumerSmsSendHandler(String msg) {
        try {
            SmsMessage smsMessage = JsonUtils.fromJson(msg, SmsMessage.class);
            return smsProcessor.send(smsMessage.getPhone(), smsMessage.getSignName(), smsMessage.getTemplateCode(), smsMessage.getTemplateParam().toString());
        } catch (Exception e) {
            log.error("CONSUMER SMS FAIL ==> {}", e.getMessage(), e);
            return false;
        }
    }

    protected abstract String getRedisStreamKey();
}
