package com.liquidnet.service.account.funding.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.account.funding.entity.FinAccountBill;
import com.liquidnet.service.account.funding.mapper.FinAccountBillMapper;
import com.liquidnet.service.account.funding.service.FinAccountBillService;
import com.liquidnet.service.account.funding.vo.AccountBalanceInfo;
import com.liquidnet.service.account.funding.vo.FundingAccountInfo;
import com.liquidnet.service.account.util.FinUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

@Service
public class FinAccountBillServiceImpl implements FinAccountBillService {
    private static final Logger log = LoggerFactory.getLogger(FinAccountBillServiceImpl.class);
    @Autowired
    private FinAccountBillMapper accountBillMapper;

    @Override
    public List<FundingAccountInfo> queryByAccNoForGroup(String finId, List<String> accNoList) {
        String moduloTableName = "FIN_AC_N02_" + FinUtil.modSeq(finId, 25);
        List<AccountBalanceInfo> accountBalanceInfoList = accountBillMapper.selectByAccNoForGroup(moduloTableName, accNoList);
        return JsonUtils.fromJson(JsonUtils.toJson(accountBalanceInfoList),
                new TypeReference<List<FundingAccountInfo>>() {
                });
    }

    @Override
    public int addAccountBill(FinAccountBill record) {
        return accountBillMapper.insertSelective(record);
    }

    @Override
    public BigDecimal queryCurrentBalance(String finId, String accNo, String billNo) {
        String moduloTableName = "FIN_AC_N02_" + FinUtil.modSeq(finId, 25);
        return accountBillMapper.selectCurrentBalance(moduloTableName, accNo, billNo);
    }
}
