package com.liquidnet.service.bank.config;

import com.currencycloud.client.CurrencyCloudClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CurrencyCloudConfig {

    // login id
    @Value("${liquidnet.conf.currencycloud.auth.login_id}")
    private String loginId;

    // api key
    @Value("${liquidnet.conf.currencycloud.auth.api_key}")
    private String apiKey;

    // environment
    @Value("${liquidnet.conf.currencycloud.auth.environment}")
    private String environment;

    @Bean
    public CurrencyCloudClient initCurrencyCloudClient() {
        return new CurrencyCloudClient(CurrencyCloudClient.Environment.valueOf(environment), loginId, apiKey);
    }

}
