package com.liquidnet.service.platform.service.impl.adam.dm.processor;

import com.liquidnet.service.adam.dto.vo.AdamMemberPriceVo;
import com.liquidnet.service.adam.dto.vo.AdamMemberSimpleVo;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.mapper.AdamMemberMapper;
import com.liquidnet.service.adam.mapper.AdamMemberPriceMapper;
import com.liquidnet.service.platform.service.impl.adam.dm.DataMigrationProcessorService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class DMTracesInfoProcessor extends DataMigrationProcessorService {
    @Autowired
    AdamMemberMapper memberMapper;
    @Autowired
    AdamMemberPriceMapper memberPriceMapper;

    @Override
    public void dataProcessing(Integer dg, Integer dG, String incrDt, String flg, String flu) {
        if (StringUtils.isNotEmpty(flu)) {
            log.info("DM.flush.member:{}", userMapper.executeForDM("adam_member"));
            log.info("DM.flush.member_price:{}", userMapper.executeForDM("adam_member_price"));

//            log.info("DM.flush.AdamMemberVo:{}", mongoTemplate.remove(Query.query(Criteria.where("_id").exists(true)), AdamMemberVo.class.getSimpleName()).getDeletedCount());
//            log.info("DM.flush.AdamMemberPriceVo:{}", mongoTemplate.remove(Query.query(Criteria.where("_id").exists(true)), AdamMemberPriceVo.class.getSimpleName()).getDeletedCount());
        }
        this.memberCardInfoHandler();
        this.memberCardPriceHandler();
        this.userMemberBlackListHandler();
        this.setRdsCache();
    }

    @SneakyThrows
    private void memberCardInfoHandler() {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSetImpl row = null;
        try {
            String sql = "select id,`name`,sub_title,icon,avatar,min_card_number,if(`type`='VIP',1,0),interests_detail,notes,created_at,updated_at,is_notice,vip_notice,vip_notice_title,need_question,display_agreement,status,limitation from vip_cards";
//        1-id,2-`name`,3-sub_title,4-icon,5-avatar,6-min_card_number,7-`type`,8-interests_detail,9-notes,10-created_at,11-updated_at,12-is_notice,13-vip_notice,14-vip_notice_title,15-need_question,16-display_agreement,17-status,18-limitation

            Class.forName(DB_DRIVER);
            connection = DriverManager.getConnection(DB_URL + DB_NAME_PASSPORT, DB_USER, DB_PWD);
            log.info("DM.execute ----------------------------> start.sql:{}", sql);
            statement = connection.prepareStatement(sql);
            row = (ResultSetImpl) statement.executeQuery();
            row.first();

            AdamMember o = new AdamMember();
            o.setMemberId(row.getString(1));
            o.setName(row.getString(2));
            o.setTitle(o.getName());
            o.setSubTitle(row.getString(3));
            o.setIcon(row.getString(4));
            o.setAvatar(row.getString(5));
            o.setStartNo(10000);
            o.setType(row.getInt(7));
            o.setInterestsDetail(row.getString(8));
            o.setNotes(row.getString(9));
            o.setCreatedAt(row.getLocalDateTime(10));
            o.setUpdatedAt(row.getLocalDateTime(11));
            o.setIsNotice(row.getInt(12));
            o.setNoticeInfo(row.getString(13));
            o.setNoticeTitle(row.getString(14));
            o.setNeedQuestion(row.getInt(15));
            o.setDisplayAgreement(row.getInt(16));
            o.setState(row.getInt(17));
            o.setLimitation(row.getInt(18));

            AdamMemberVo vo = AdamMemberVo.getNew().copy(o);

            dmRdmService.setMemberVoByMemberId(vo.getMemberId(), vo);
            dmRdmService.setMemberSimpleVo(AdamMemberSimpleVo.getNew().copy(vo));

            memberMapper.insert(o);
//            mongoTemplate.insert(vo, AdamMemberVo.class.getSimpleName());

            log.info("DM.execute ----------------------------> end");

            row.close();
            statement.close();
            connection.close();
        } catch (Exception throwables) {
            throwables.printStackTrace();
        }
        try {
            if (null != row) row.close();
        } catch (SQLException ignored) {
        }
        try {
            if (null != statement) statement.close();
        } catch (SQLException ignored) {
        }
//        try {
//            if (null != connection) connection.close();
//        } catch (SQLException ignored) {
//        }
    }

    @SneakyThrows
    private void memberCardPriceHandler() {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSetImpl row = null;
        try {
            String sql = "select id,vip_card_id,status,name,price,days,detail,created_at,updated_at from vip_card_prices";
//        1-id,2-vip_card_id,3-status,4-name,5-price,6-days,7-detail,8-created_at,9-updated_at

            Class.forName(DB_DRIVER);
            connection = DriverManager.getConnection(DB_URL + DB_NAME_PASSPORT, DB_USER, DB_PWD);
            log.info("DM.execute ----------------------------> start.sql:{}", sql);
            statement = connection.prepareStatement(sql);
            row = (ResultSetImpl) statement.executeQuery();
            row.first();

            AdamMemberPrice o = new AdamMemberPrice();
            o.setMemberPriceId(row.getString(1));
            o.setMemberId(row.getString(2));
            o.setState(row.getInt(3));
            o.setName(row.getString(4));
            o.setPrice(row.getBigDecimal(5));
            o.setPriceFixed(o.getPrice());
            o.setDays(row.getInt(6));
            o.setDetail(row.getString(7));
            o.setCreatedAt(row.getLocalDateTime(8));
            o.setUpdatedAt(row.getLocalDateTime(9));

            AdamMemberPriceVo vo = AdamMemberPriceVo.getNew().copy(o);

            ArrayList<AdamMemberPriceVo> objectArrayList = new ArrayList<>();
            objectArrayList.add(vo);
            dmRdmService.setMemberPriceVoByMemberId(vo.getMemberId(), objectArrayList);

            memberPriceMapper.insert(o);
//            mongoTemplate.insert(vo, AdamMemberPriceVo.class.getSimpleName());

            log.info("DM.execute ----------------------------> end");

            row.close();
            statement.close();
            connection.close();
        } catch (Exception throwables) {
            throwables.printStackTrace();
        }
        try {
            if (null != row) row.close();
        } catch (SQLException ignored) {
        }
        try {
            if (null != statement) statement.close();
        } catch (SQLException ignored) {
        }
//        try {
//            if (null != connection) connection.close();
//        } catch (SQLException ignored) {
//        }
    }

    @SneakyThrows
    private void userMemberBlackListHandler() {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSetImpl row = null;
        try {
            String sql = "select distinct uid from vip_black_list_record where status=0 and uid is not null and uid<>''";

            Class.forName(DB_DRIVER);
            connection = DriverManager.getConnection(DB_URL + DB_NAME_PASSPORT, DB_USER, DB_PWD);
            statement = connection.prepareStatement(sql);
            row = (ResultSetImpl) statement.executeQuery();
            log.info("DM.execute ----------------------------> start.sql:{}", sql);

            List<String> userMemberBlackList = new ArrayList<>();
            while (row.next()) {
                userMemberBlackList.add(row.getString(1));
            }

            boolean rst = dmRdmService.setBlacklistForMember(userMemberBlackList);

            log.info("DM.execute ----------------------------> end.counts:{} - {}", userMemberBlackList.size(), rst);
            row.close();
            statement.close();
            connection.close();
        } catch (Exception throwables) {
            throwables.printStackTrace();
        }
        try {
            if (null != row) row.close();
        } catch (SQLException ignored) {
        }
        try {
            if (null != statement) statement.close();
        } catch (SQLException ignored) {
        }
//        try {
//            if (null != connection) connection.close();
//        } catch (SQLException ignored) {
//        }
    }

    private void setRdsCache() {
//        dmRdmService.setSwitch(AdamRedisConst.SWITCH_GRAY_LOGIN_SMS, 612543);
//        log.info("switch {}:{}", AdamRedisConst.SWITCH_GRAY_LOGIN_SMS, dmRdmService.getSwitch(AdamRedisConst.SWITCH_GRAY_LOGIN_SMS));
    }
}
