package com.liquidnet.service.goblin.controller.manage;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateUpdateParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueParam;
import com.liquidnet.service.goblin.dto.manage.vo.AnticipateValueVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigInteger;
import java.util.List;

/**
 * <p>
 * 预约表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Slf4j
@RestController
@Api(tags = "预约相关")
@RequestMapping("/goblin/anticipate")
public class GoblinGoodsAnticipateMgController {

    @Autowired
    IGoblinGoodsAnticipateService goblinGoodsAnticipateService;

    @ApiOperation("创建预约信息")
    @PostMapping("/add")
    public ResponseDto<Object> add(@RequestBody GoblinGoodsAnticipateAddParam goodsAnticipateAddParam) {
        return goblinGoodsAnticipateService.add(goodsAnticipateAddParam);
    }

    @PostMapping("/list")
    @ApiOperation("获取全部开启预约的sku")
    public ResponseDto<PageInfo<GoblinGoodsAnticipateValueVo>> list(GoblinGoodsAnticipateValueParam goodsAnticipateValueParam) {
        return goblinGoodsAnticipateService.list(goodsAnticipateValueParam);
    }

    @ApiOperation("修改预约人数")
    @PostMapping("/updatePeople")
    public ResponseDto<Object> updatePeople(@RequestParam(name = "skuId", required = true) String skuId, @RequestParam(name = "people", required = true) BigInteger people) {
        return goblinGoodsAnticipateService.updatePeople(skuId, people);
    }

    @ApiOperation("删除预约")
    @DeleteMapping("/delete")
    public ResponseDto<Object> delete(@RequestParam(name = "skuId") String skuId) {
        return goblinGoodsAnticipateService.delete(skuId);
    }

    @ApiOperation("更具sku获取信息")
    @GetMapping("/getAnticipateValueBySkuId")
    public ResponseDto<AnticipateValueVo> getAnticipateValueBySkuId(@RequestParam(name = "skuId") String skuId){
        return goblinGoodsAnticipateService.getAnticipateValueBySkuId(skuId);
    }

}
