/**
 * $Id: RestControllerAdviceHandler.java 13331 2016-07-06 09:09:33Z anjiabin $
 * Copyright(C) 2014-2020 easegame, All Rights Reserved.
 */
package com.liquidnet.common.exception;

import com.alibaba.fastjson.JSON;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.exception.entity.Error;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: TODO
 * @class: RestControllerAdviceHandler
 * @Package com.liquidnet.common.exception
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/21 10:37
 */
@ControllerAdvice(annotations = RestController.class)
public class RestControllerAdviceHandler {
    private final Logger logger = LoggerFactory.getLogger(RestControllerAdviceHandler.class);

    @ExceptionHandler(value = Exception.class)
    @ResponseBody
    public ResponseEntity<Error> serviceExceptionHandler(Exception rex, WebRequest request) {
        logger.error("serviceExceptionHandler request:{},param:{}", request.getContextPath(), JSON.toJSONString(request.getParameterMap()));
        if (rex instanceof ConstraintViolationException) {
            ConstraintViolationException ygex = ((ConstraintViolationException) rex);
            String message = ((ConstraintViolation) ygex.getConstraintViolations().toArray()[0]).getMessage();
            logger.error("ConstraintViolationException code:{},msg:{}", ErrorCode.HTTP_PARAM_ERROR.getCode(), message);
            return new ResponseEntity<Error>(new Error(ErrorCode.HTTP_PARAM_ERROR.getCode(), message), HttpStatus.OK);
        }
        if (rex instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException ygex = ((MissingServletRequestParameterException) rex);
            String message = ygex.getMessage();
            logger.error("ConstraintViolationException code:{},msg:{}", ErrorCode.HTTP_PARAM_ERROR.getCode(), message);
            return new ResponseEntity<Error>(new Error(ErrorCode.HTTP_PARAM_ERROR.getCode(), message), HttpStatus.OK);
        }
        if (rex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException ygex = ((MethodArgumentNotValidException) rex);
            String message = ygex.getBindingResult().getFieldErrors().get(0).getDefaultMessage();
            logger.error("ConstraintViolationException code:{},msg:{}", ErrorCode.HTTP_PARAM_ERROR.getCode(), message);
            return new ResponseEntity<Error>(new Error(ErrorCode.HTTP_PARAM_ERROR.getCode(), message), HttpStatus.OK);
        }
        if (rex instanceof LiquidnetFeignException) {
            LiquidnetFeignException ygex = ((LiquidnetFeignException) rex);
            String errorCode = ygex.errorCode().getCode();
            String message = ygex.getMessage();
            message = message == null ? ygex.errorCode().getMessage() : message;
            logger.error("LiquidnetFeignException code:{},msg:{}", errorCode, ygex.getMessage());
            return new ResponseEntity<Error>(new Error(errorCode, message), HttpStatus.OK);
        }
        if (rex instanceof LiquidnetServiceException) {
            LiquidnetServiceException ygex = ((LiquidnetServiceException) rex);
            String errorCode = ygex.errorCode().getCode();
            String message = ygex.getMessage();
            message = message == null ? ygex.errorCode().getMessage() : message;
            logger.error("LiquidnetServiceException code:{},msg:{}", errorCode, ygex.getMessage());
            return new ResponseEntity<Error>(new Error(errorCode, message), HttpStatus.OK);
        } else {
            logger.error("serviceExceptionHandler unknown exception", rex);
            return new ResponseEntity<Error>(new Error(ErrorCode.HTTP_SYSTEM_ERROR.getCode(), ErrorCode.HTTP_SYSTEM_ERROR.getMessage()), HttpStatus.OK);
        }
    }
}
