package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.utils.TaobaoTicketUtils;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.other.DamaiService;
import com.taobao.api.TaobaoClient;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.request.AlibabaDamaiMevOpenPushitemRequest;
import com.taobao.api.request.AlibabaDamaiMevOpenPushitemRequest.PushTicketItemPushOpenParam;
import com.taobao.api.request.AlibabaDamaiMevOpenPushperformRequest;
import com.taobao.api.request.AlibabaDamaiMevOpenPushperformRequest.ThirdPerformPushOpenParam;
import com.taobao.api.request.AlibabaDamaiMevOpenPushprojectRequest;
import com.taobao.api.request.AlibabaDamaiMevOpenPushprojectRequest.ThirdProjectPushOpenParam;
import com.taobao.api.response.AlibabaDamaiMevOpenPushfaceResponse;
import com.taobao.api.response.AlibabaDamaiMevOpenPushitemResponse;
import com.taobao.api.response.AlibabaDamaiMevOpenPushperformResponse;
import com.taobao.api.response.AlibabaDamaiMevOpenPushprojectResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.stereotype.Service;

import java.time.format.DateTimeFormatter;
import java.util.List;


/**
 * <p>
 * 巡演 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
@Service
public class KylinDamaiServiceImpl extends ServiceImpl<KylinRoadShowsMapper, KylinRoadShows> implements DamaiService {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private TaobaoTicketUtils taobaoTicketUtils;

    @Autowired
    private KylinPerformancesMapper performancesMapper;

    @Autowired
    private KylinTicketTimesMapper ticketTimesMapper;
    @Autowired
    private KylinTicketTimeRelationMapper ticketTimeRelationMapper;

    @Autowired
    private KylinTicketsMapper ticketsMapper;
    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;


    @Override
    public Boolean sycField(String fieldId) {
        return null;
    }

    @Override
    public Boolean sycPerformance(String performanceId) {
        try {
            TaobaoClient client = taobaoTicketUtils.initTaobaoClient();
            AlibabaDamaiMevOpenPushprojectRequest req = new AlibabaDamaiMevOpenPushprojectRequest();
            ThirdProjectPushOpenParam obj1 = new ThirdProjectPushOpenParam();

            KylinPerformances performanceData = performancesMapper.selectOne(new UpdateWrapper<KylinPerformances>().eq("performances_id", performanceId));

            obj1.setPicUrl(performanceData.getImgPoster());
            obj1.setProjectId(Long.parseLong(performanceData.getPerformancesId()));
            obj1.setProjectName(performanceData.getTitle());
            obj1.setCityId(performanceData.getCityId().longValue());
            obj1.setSupplierSecret(taobaoTicketUtils.getSupplierSecret());
            obj1.setSystemId(taobaoTicketUtils.getSystemId());

//            obj1.setPushTime(DateUtils.getNowDate());
//            obj1.setSupplierSecret("foo");
//            obj1.setSystemId(0L);
//            obj1.setVenueId(0L);

            req.setPushProjectParam(obj1);
            AlibabaDamaiMevOpenPushprojectResponse rsp = client.execute(req);
            if (rsp.getResult().getSuccess()) {
                List<KylinTicketTimeRelation> timeRelation = ticketTimeRelationMapper.selectList(new UpdateWrapper<KylinTicketTimeRelation>().eq("performance_id", performanceId));

                for (int i = 0; i < timeRelation.size(); i++) {
                    KylinTicketTimes timeData = ticketTimesMapper.selectOne(new UpdateWrapper<KylinTicketTimes>().eq("ticket_times_id", timeRelation.get(i).getTimesId()));
                    boolean result = sycTimes(performanceId, timeData);
                    if (!result) {
                        return false;
                    }
                }
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Boolean sycTimes(String performancesId, KylinTicketTimes timesData) {
        try {
            TaobaoClient client = taobaoTicketUtils.initTaobaoClient();
            AlibabaDamaiMevOpenPushperformRequest req = new AlibabaDamaiMevOpenPushperformRequest();
            ThirdPerformPushOpenParam obj1 = new ThirdPerformPushOpenParam();

            obj1.setEndTime(StringUtils.parseDateTime(timesData.getUseEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))));
            obj1.setPerformId(Long.parseLong(timesData.getTicketTimesId()));
            obj1.setPerformName(timesData.getTitle());
            obj1.setProjectId(Long.parseLong(performancesId));
            obj1.setStartTime(StringUtils.parseDateTime(timesData.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))));
            obj1.setSupplierSecret(taobaoTicketUtils.getSupplierSecret());
            obj1.setSystemId(taobaoTicketUtils.getSystemId());
            req.setPushPerformParam(obj1);
            AlibabaDamaiMevOpenPushperformResponse rsp = client.execute(req);
            if (rsp.getResult().getSuccess()) {
                List<KylinTicketRelations> ticketRelation = ticketRelationsMapper.selectList(new UpdateWrapper<KylinTicketRelations>().eq("times_id", timesData.getTicketTimesId()));
                for (int i = 0; i < ticketRelation.size(); i++) {
                    KylinTickets ticketData = ticketsMapper.selectOne(new UpdateWrapper<KylinTickets>().eq("tickets_id", ticketRelation.get(i).getTicketId()));
                    boolean result = sycTicket(timesData.getTicketTimesId(), ticketData);
                    if (!result) {
                        return false;
                    }
                }
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Boolean sycTicket(String timeId, KylinTickets ticketsData) {
        try {
            TaobaoClient client = taobaoTicketUtils.initTaobaoClient();
            AlibabaDamaiMevOpenPushitemRequest req = new AlibabaDamaiMevOpenPushitemRequest();
            PushTicketItemPushOpenParam obj1 = new PushTicketItemPushOpenParam();

            obj1.setItemId(Long.parseLong(ticketsData.getTicketsId()));
            obj1.setItemName(ticketsData.getTitle());
            obj1.setItemPrice(ticketsData.getPrice().longValue());
            obj1.setPerformId(Long.parseLong(timeId));
            obj1.setSupplierSecret(taobaoTicketUtils.getSupplierSecret());
            obj1.setSystemId(taobaoTicketUtils.getSystemId());
//            obj1.setRemark("0");
            req.setPushItemParam(obj1);
            AlibabaDamaiMevOpenPushitemResponse rsp = client.execute(req);
            return rsp.getResult().getSuccess();
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
