package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel(value = "AdamMemberOrderCodeParam", description = "使用兑换码入参")
@Data
public class AdamMemberOrderCodeParam implements Serializable {
    private static final long serialVersionUID = 2500742355642406263L;
    @ApiModelProperty(position = 10, required = true, value = "类型:2-会员码,3-礼包码", example = "3")
    @NotNull
    @Min(2)
    @Max(3)
    private Integer mode;
    @ApiModelProperty(position = 11, required = true, value = "兑换码", example = "0")
    @NotBlank
    private String memberCode;
    @ApiModelProperty(position = 12, value = "支付终端[app,wap,js,applet]", example = "js")
    private String deviceFrom;

    @ApiModelProperty(position = 13, required = false, value = "姓名")
    private String name;
    @ApiModelProperty(position = 14, required = false, value = "身份证件号")
    private String idCard;
}
