package com.liquidnet.service.sweet.config;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PayAlipayUtils {
    private static PayAlipayUtils instance = new PayAlipayUtils();
    private final String sign_type = "RSA2";
    private final String charset = "utf-8";
    private final String gatewayUrl = "https://openapi.alipay.com/gateway.do";
    /*支付宝小程序*/
    private AlipayClient httpClientApplet= null;
    private  static  String appletMerchantPrivateKey;
    private  static  String appletAppId;
    private  static  String appletMerchantPubKey;

    @Value("${liquidnet.alipay.applet.privateKey}")
    public void setAppletMerchantPrivateKey(String appletMerchantPrivateKey) {
        PayAlipayUtils.appletMerchantPrivateKey = appletMerchantPrivateKey;
    }
    @Value("${liquidnet.alipay.applet.appId}")
    public void setAppletAppId(String appletAppId) {
        PayAlipayUtils.appletAppId = appletAppId;
    }
    @Value("${liquidnet.alipay.applet.pubKey}")
    public void setAppletMerchantPubKey(String pubKey) {
        PayAlipayUtils.appletMerchantPubKey = pubKey;
    }
    public PayAlipayUtils() {

    }
    public static PayAlipayUtils getInstance() {
        return instance;
    }
    public AlipayClient getHttpClientApplet() {
        if(httpClientApplet == null){
            httpClientApplet = new DefaultAlipayClient(gatewayUrl, appletAppId, appletMerchantPrivateKey, "json", charset,
                    appletMerchantPubKey, sign_type);
        }
        return httpClientApplet;
    }
}
