package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "AdamDisposedBaseVo", description = "想去基础数据")
@Data
public class AdamDisposedBaseVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 3910252748178007996L;
    @ApiModelProperty(position = 10, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 11, value = "用户头像[255]")
    private String avatar;
    @ApiModelProperty(position = 12, value = "用户昵称[32]")
    private String nickname;
    @ApiModelProperty(position = 13, value = "用户性别[32]")
    private AdamTagVo sex;
    @ApiModelProperty(position = 14, value = "内容ID[64]")
    private String contentId;
    @ApiModelProperty(position = 15, value = "内容类型")
    private String type;
    @ApiModelProperty(position = 16, value = "内容类型")
    private Integer state;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private static final AdamDisposedBaseVo obj = new AdamDisposedBaseVo();

    public static AdamDisposedBaseVo getNew() {
        try {
            return (AdamDisposedBaseVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamDisposedBaseVo();
        }
    }
}
