package com.liquidnet.service.reconciliation.strategy.funddata;

import com.liquidnet.service.reconciliation.strategy.funddata.annotation.StrategyGetFundDataHandler;
import com.liquidnet.service.reconciliation.strategy.transtype.annotation.StrategyTransTypeHandler;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 服务启动初始化策略容器-资金数据获取
 * @class: GetFundDataStrategyListener
 * @Package com.liquidnet.service.reconciliation.strategy.transtype
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:38
 */
@Component
public class GetFundDataStrategyListener implements ApplicationListener<ContextRefreshedEvent> {

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(StrategyGetFundDataHandler.class);
        GetFundDataStrategyContext strategyContext = event.getApplicationContext().getBean(GetFundDataStrategyContext.class);
        beans.forEach((name, bean) -> {
            StrategyGetFundDataHandler typeHandler = bean.getClass().getAnnotation(StrategyGetFundDataHandler.class);
            strategyContext.putStrategy(typeHandler.value().getCode(), (IGetFundDataStrategy) bean);
        });
    }
}