package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT购买(涉及NFT发行、NFT购买)
 * @class: GalaxyNftPublishAndBuyReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/17 13:51
 */
@ApiModel(value = "GalaxyNftPublishAndBuyReqDto", description = "NFT发行购买")
@Data
public class GalaxyNftPublishAndBuyReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    /**
     * 以下为发行参数***********************************
     */
    @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
    @NotBlank(message = "用户ID不能为空！")
    @Size(min = 1, max = 30, message = "用户ID限制2-30位且不能包含特殊字符")
    private String userId;

    /**
     * skuId
     */
    @ApiModelProperty(position = 1, required = true, value = "系列唯一id标识，不超过20个字符")
    @NotBlank(message = "skuId不能为空！")
    @Size(min = 2, max = 20, message = "skuId限制2-20位且不能包含特殊字符")
    private String skuId;

    /**
     * nftOrderPayId
     */
    @ApiModelProperty(position = 1, required = true, value = "nft订单支付id(保证唯一)，不超过30个字符")
    @NotBlank(message = "nft订单支付id不能为空")
    @Size(min = 2, max = 30, message = "nft订单支付id限制2-30位且不能包含特殊字符")
    private String nftOrderPayId;

    /**
     * buyTimestamp
     */
    @ApiModelProperty(position = 3, required = true, value = "购买时间戳(格式为：2022-04-07 12:12:12)")
    @NotBlank(message = "购买时间戳")
    private String buyTimestamp;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftPublishAndBuyReqDto obj = new GalaxyNftPublishAndBuyReqDto();

    public static GalaxyNftPublishAndBuyReqDto getNew() {
        try {
            return (GalaxyNftPublishAndBuyReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftPublishAndBuyReqDto();
        }
    }
}
