package com.liquidnet.service.goblin.service.impl.inner;

import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.galaxy.dto.param.GalaxyArtSeriesClaimReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyArtSeriesClaimRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftUploadReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftUploadRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;

import java.util.List;

/**
 * Galaxy服务接口调用
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2022/4/1
 */
@Slf4j
@Service
public class GoblinGalaxyService {
    @Autowired
    Environment env;
//    @Value("${liquidnet.service.galaxy.url}")// TODO: 2022/3/31 ==zhanggb
//    private String sevGalaxyUrl;

    /**
     * NFT素材上传
     *
     * @param nftUploadReqDto GalaxyNftUploadReqDto
     * @return GalaxyNftUploadRespDto
     */
    public GalaxyNftUploadRespDto uploadNftMaterial(GalaxyNftUploadReqDto nftUploadReqDto) {
//        String postUrl = sevGalaxyUrl + "/user/register", blockChainAddress;// TODO: 2022/3/31 ==zhanggb
        String postUrl = "https://ENVgalaxy.zhengzai.tv/galaxy/artwork/nftUpload".replace("ENV", env.getProperty(CurrentUtil.CK_ENV_ACTIVE)), blockChainAddress;
        String postBody = JsonUtils.toJson(nftUploadReqDto);
        try {
            String postRespStr = HttpUtil.postRaw(postUrl, postBody, null);
            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class), postRespCode;
            if (null == postRespJNode || null == (postRespCode = postRespJNode.get("code")) || !postRespCode.asText().equals("0")) {
                log.warn("#NFT素材上传:请求失败[paramsStr={},postRespStr={}]", postBody, postRespStr);
                return null;
            }
            return JsonUtils.OM().convertValue(postRespJNode.get("data"), GalaxyNftUploadRespDto.class);
        } catch (Exception e) {
            log.error("Ex.NFT素材上传:请求异常[url={},paramsStr={}],ex:{}", postUrl, postBody, e.getMessage());
            return null;
        }
    }

    /**
     * NFT系列声明
     *
     * @param seriesClaimReqDto GalaxyArtSeriesClaimReqDto
     * @return GalaxyArtSeriesClaimRespDto
     */
    public GalaxyArtSeriesClaimRespDto claimNftSeries(GalaxyArtSeriesClaimReqDto seriesClaimReqDto) {
//        String postUrl = sevGalaxyUrl + "/user/register", blockChainAddress;// TODO: 2022/3/31 ==zhanggb
        String postUrl = "https://ENVgalaxy.zhengzai.tv/galaxy/artwork/nftUpload".replace("ENV", env.getProperty(CurrentUtil.CK_ENV_ACTIVE)), blockChainAddress;
        String postBody = JsonUtils.toJson(seriesClaimReqDto);
        try {
            String postRespStr = HttpUtil.postRaw(postUrl, postBody, null);
            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class), postRespCode;
            if (null == postRespJNode || null == (postRespCode = postRespJNode.get("code")) || !postRespCode.asText().equals("0")) {
                log.warn("#NFT系列声明:请求失败[paramsStr={},postRespStr={}]", postBody, postRespStr);
                return null;
            }
            return JsonUtils.OM().convertValue(postRespJNode.get("data"), GalaxyArtSeriesClaimRespDto.class);
        } catch (Exception e) {
            log.error("Ex.NFT系列声明:请求异常[url={},paramsStr={}],ex:{}", postUrl, postBody, e.getMessage());
            return null;
        }
    }

    /**
     * NFT发行、购买结果查询
     *
     * @param uid
     * @param orderId
     * @param routerType
     * @return
     */
    public List<String> checkNftTradeResult(String uid, String orderId, String routerType) {
        LinkedMultiValueMap<String, String> paramsMap = CollectionUtil.linkedMultiValueMapStringString();
        paramsMap.add("userId", uid);
        paramsMap.add("nftOrderPayId", orderId);// TODO: 2022/3/31 ==zhanggb
        paramsMap.add("routerType", routerType);

//        String postUrl = sevGalaxyUrl + "/user/register", blockChainAddress;// TODO: 2022/3/31 ==zhanggb
        String postUrl = "https://ENVgalaxy.zhengzai.tv/galaxy/nftTrade/nftPublishAndBuyResultQuery".replace("ENV", env.getProperty(CurrentUtil.CK_ENV_ACTIVE)), blockChainAddress;
        try {
            LinkedMultiValueMap<String, String> headerMap = CollectionUtil.linkedMultiValueMapStringString();
            headerMap.add("Accept", MediaType.APPLICATION_JSON_VALUE);
            String postRespStr = HttpUtil.post(postUrl, paramsMap, headerMap);
            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class), postRespCode;
            if (null == postRespJNode || null == (postRespCode = postRespJNode.get("code")) || !postRespCode.asText().equals("0")) {
                log.warn("#NFT发行购买结果查询:查询失败[paramsMap={},postRespStr={}]", paramsMap, postRespStr);
                return null;
            }
            JsonNode postRespDataJNode = postRespJNode.get("data");

            List<String> respDataList = CollectionUtil.arrayListString();
            respDataList.add(postRespDataJNode.get("nftId").asText());
            respDataList.add(postRespDataJNode.get("nftPublishChainTimestamp").asText());
            respDataList.add(postRespDataJNode.get("nftPublishTxHash").asText());
            respDataList.add(postRespDataJNode.get("nftBuyChainTimestamp").asText());
            respDataList.add(postRespDataJNode.get("nftBuyTxHash").asText());
            return respDataList;
        } catch (Exception e) {
            log.error("Ex.NFT发行购买结果查询:请求异常[UID={},url={},paramsMap={}],ex:{}", uid, postUrl, paramsMap, e.getMessage());
            return null;
        }
    }
}
