package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.entity.GoblinNftExActivity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author: wll
 * @Description: nft 兑换活动表
 * @Date:Create：in 2022/4/19 2:14 下午
 */

@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftExActivityVo implements Serializable,Cloneable {


    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;


    /**
     * 活动id
     */
    @ApiModelProperty(position = 10,required = true,value ="活动id")
    private String activityId;

    /**
     * 活动标题
     */
    @ApiModelProperty(position = 11,required = true,value ="活动标题")
    private String title;

    /**
     * 创建时间
     */
    @ApiModelProperty(position = 12,required = true,value ="创建时间")
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @ApiModelProperty(position = 13,required = true,value ="更新时间")
    private LocalDateTime updatedAt;

    /**
     * 总数量
     */
    @ApiModelProperty(position = 14,required = true,value ="总数量")
    private Integer countNumber;

    /**
     * 使用数量
     */
    @ApiModelProperty(position = 15,required = true,value ="使用数量")
    private Integer useNumber;

    /**
     * 未使用数量
     */
    @ApiModelProperty(position = 16,required = true,value ="未使用数量")
    private Integer unUseNumber;

    @ApiModelProperty(position = 17,required = true,value ="sku基本所属信息集合")
    private List<GoblinNftSkuVo> goblinNftSkuVos;


    private  final  static GoblinNftExActivityVo obj = new GoblinNftExActivityVo();

    public static GoblinNftExActivityVo getNew(){
        try {
            return  (GoblinNftExActivityVo) obj.clone();
        }catch (CloneNotSupportedException e){
            return new GoblinNftExActivityVo();
        }
    }

    public GoblinNftExActivityVo copy(GoblinNftExActivity goblinNftExActivity){
        if (null == goblinNftExActivity) return this;
        this.setActivityId(goblinNftExActivity.getActivityId());
        this.setTitle(goblinNftExActivity.getTitle());
        this.setCreatedAt(goblinNftExActivity.getCreatedAt());
        this.setUpdatedAt(goblinNftExActivity.getUpdatedAt());
        this.setCountNumber(goblinNftExActivity.getCountNumber());
        this.setUseNumber(goblinNftExActivity.getUseNumber());
        this.setUnUseNumber(goblinNftExActivity.getUnUseNumber());
        return this;
    }

}


