package com.liquidnet.service.goblin.service;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExActivityVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftSkuVo;
import com.liquidnet.service.goblin.param.GoblinNftExActivityParam;

import java.util.List;

public interface IGoblinNftExActivityService {

    /**
     * 新增nft活动
     * @param goblinNftExActivityParam
     * @return
     */
    String add(GoblinNftExActivityParam goblinNftExActivityParam);

    /**
     * 分页查询
     * @param goblinNftExActivityParam
     * @return
     */
    PageInfo<GoblinNftExActivityVo> pageList(GoblinNftExActivityParam goblinNftExActivityParam);

    /**
     * 根据活动id获取活动下商品
     * @param activityId
     * @return
     */
    List<GoblinNftSkuVo> selectNftSkuByActivityId(String activityId);
}
