package com.liquidnet.service.kylin.dto.vo.mongo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.entity.KylinFields;
import com.liquidnet.service.kylin.entity.KylinPerformanceRelations;
import com.liquidnet.service.kylin.entity.KylinPerformanceStatus;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class KylinPerformanceVo implements Serializable, Cloneable {

    private Integer mid;
    @ApiModelProperty(value = "主键")
    private String performancesId;
    @ApiModelProperty(value = "演出名称")
    private String title;
    @ApiModelProperty(value = "演出图片")
    private String imgPoster;
    @ApiModelProperty(value = "支付倒计时")
    private Integer payCountdownMinute;
    @ApiModelProperty(value = "演出批文地址")
    private String approvalUrl;
    @ApiModelProperty(value = "101音乐节 102小型演出(livehouse演出) 103巡演")
//    @ApiModelProperty(value = "演出类型 1音乐节 2演唱会 3小型演出 4展览 6舞台剧 101音乐节 102小型演出(livehouse演出) 103巡演")
    private Integer type;
    @ApiModelProperty(value = "演出开始时间")
    private String timeStart;
    @ApiModelProperty(value = "演出结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "停售时间")
    private String stopSellTime;
    @ApiModelProperty(value = "价格")
    private String price;
    @ApiModelProperty(value = "开售时间")
    private String sellTime;
    @ApiModelProperty(value = "会员开售时间")
    private String sellMemberTime;
    @ApiModelProperty(value = "城市id")
    private Integer cityId;
    @ApiModelProperty(value = "城市名称")
    private String cityName;
    @ApiModelProperty(value = "场地id")
    private String fieldId;
    @ApiModelProperty(value = "场地名称")
    private String fieldName;
    @ApiModelProperty(value = "经度")
    private String longitude;
    @ApiModelProperty(value = "纬度")
    private String latitude;
    @ApiModelProperty(value = "场地距离当前位置距离")
    private String diffDistance;
    @ApiModelProperty(value = "搭售id")
    private String projectId;
    @ApiModelProperty(value = "巡演id")
    private String roadShowId;
    // OSS
    @ApiModelProperty(value = "演出详情")
    private String details;
    // OSS
    @ApiModelProperty(value = "购票须知")
    private String noticeImage;

    @ApiModelProperty(value = "推荐顺序 0为不推荐")
    private Integer isRecommend;
    @ApiModelProperty(value = "状态")
    private Integer appStatus;
    @ApiModelProperty(value = "是否可买 状态 [1正常|2非正常]")
    private Integer statusSell;
    @ApiModelProperty(value = "是否关联会员")
    private Integer isMember;
    @ApiModelProperty(value = "是否开启缺票登记")
    private Integer isLackRegister;
    @ApiModelProperty(value = "是否实名")
    private Integer isTrueName;
    @ApiModelProperty(value = "限购张数")
    private Integer limitCount;
    @ApiModelProperty(value = "实名数量 0为不限购")
    private Integer idCount;
    @ApiModelProperty(value = "会员限购张数")
    private Integer limitCountMember;
    @ApiModelProperty(value = "是否专属")
    private Integer isExclusive;
    @ApiModelProperty(value = "是否优惠")
    private Integer isDiscount;
    @ApiModelProperty(value = "是否提前")
    private Integer isAdvance;
    @ApiModelProperty(value = "是否同步大麦 0 1")
    private Integer sysDamai;
    @ApiModelProperty(value = "文案")
    private String message;
    @ApiModelProperty(value = "演出公告")
    private String notice;
    @ApiModelProperty(value = "是否显示")
    private Integer isShow;
    @ApiModelProperty(value = "场次")
    private List<KylinTicketTimesVo> ticketTimeList;

    @ApiModelProperty(value = "是否开启分销[0-否|1-是]")
    private Integer isAgent;
    @ApiModelProperty(value = "分销人名称")
    private String agentName;
    @ApiModelProperty(value = "0正常、1黑名单")
    private Integer state;
    @ApiModelProperty(value = "注册时间")
    private String createdAt;

    private Integer isCanRefund;
    private Integer isOpenRefundPresent;
    private String refundOpenTime;
    private String refundCloseTime;

    private Integer isTransfer;
    private String transferStartTime;
    private String transferEndTime;

    private Integer isRefundPoundage;
    private Integer isRefundVoucher;
    private Integer isRefundExpress;
    private Integer isBackPaperTicket;
    private Integer isRefundExpressNew;

    private Integer auditStatus;
    private String rejectTxt;
    private String merchantId;
    @ApiModelProperty(value = "场地审核状态 [0-审核完成|1-待审核|2-已拒绝]", hidden = true)
    private Integer fieldAuditStatus;
    @ApiModelProperty(value = "是否预约演出 0 无 1有")
    private Integer isSubscribe;
    public Integer getIdCount() {
        return idCount == null ? limitCount : idCount;
    }

    private static final KylinPerformanceVo obj = new KylinPerformanceVo();

    public static KylinPerformanceVo getNew() {
        try {
            return (KylinPerformanceVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinPerformanceVo();
        }
    }

    //todo 阶梯退票 所有调用这个方法的地方都有改动
    public Integer getIsRefundPoundage(Integer i) {
        if(null==i || 0==i){
            return 0;
        }
        return 1;
    }

    public void setPerformance(KylinPerformances performance) {
        this.mid = performance.getMid();
        this.performancesId = performance.getPerformancesId();
        this.title = performance.getTitle();
        this.imgPoster = performance.getImgPoster();
        this.timeStart = DateUtil.Formatter.yyyyMMddHHmmss.format(performance.getTimeStart());
        this.timeEnd = DateUtil.Formatter.yyyyMMddHHmmss.format(performance.getTimeEnd());
        this.createdAt = DateUtil.Formatter.yyyyMMddHHmmss.format(performance.getCreatedAt());
        this.type = performance.getType();
        this.details = performance.getDetails();
        this.noticeImage = performance.getNoticeImage();
        this.notice = performance.getNotice();
        this.approvalUrl = performance.getApprovalUrl();
        this.rejectTxt = performance.getRejectTxt();
        if (performance.getApprovalUrl() == null || performance.getApprovalUrl().isEmpty()) {
            this.statusSell = 0;
        } else {
            this.statusSell = 1;
        }
    }

    public void initPerformancePartner(PerformancePartnerVo performance) {
        this.performancesId = performance.getPerformancesId();
        this.title = performance.getTitle();
        this.imgPoster = performance.getImgPoster();
        this.timeStart = performance.getTimeStart();
        this.timeEnd = performance.getTimeEnd();
        this.createdAt = performance.getCreatedAt();
        this.type = performance.getType();
        this.details = performance.getDetails();
        this.noticeImage = performance.getNoticeImage();
        this.notice = performance.getNotice();
        this.approvalUrl = performance.getApprovalUrl();
        this.rejectTxt = performance.getRejectTxt();
        if (performance.getApprovalUrl() == null || performance.getApprovalUrl().isEmpty()) {
            this.statusSell = 0;
        } else {
            this.statusSell = 1;
        }
    }

    public void setTimePriceVipAndLack(int isLackRegister, int isMember, int isExclusive, BigDecimal price, LocalDateTime stopSellTime, LocalDateTime sellMemberTime, LocalDateTime sellTime, int isAdvance, int isDiscount, int payCountdownMinute) {
        this.isLackRegister = isLackRegister;
        this.isMember = isMember;
        this.isExclusive = isExclusive;
        this.price = price + "起";
        this.stopSellTime = DateUtil.Formatter.yyyyMMddHHmmss.format(stopSellTime);
        this.sellMemberTime = DateUtil.Formatter.yyyyMMddHHmmss.format(sellMemberTime);
        this.sellTime = DateUtil.Formatter.yyyyMMddHHmmss.format(sellTime);
//        this.appStatus = 9;
        this.isDiscount = isDiscount;
        this.isAdvance = isAdvance;
        this.message = "";
        this.payCountdownMinute = payCountdownMinute;
    }

    public void setFieldsData(KylinFields fields, String cityName) {
        this.longitude = fields.getLongitude();
        this.latitude = fields.getLatitude();
        this.cityName = cityName;
        this.fieldName = fields.getName();
        this.cityId = fields.getCityId();
    }

    public void setPerformanceStatus(KylinPerformanceStatus performanceStatus) {
        this.statusSell = performanceStatus.getStatusSell();
        this.isRecommend = performanceStatus.getIsRecommend();
        this.isTrueName = performanceStatus.getIsTrueName();
        this.limitCount = performanceStatus.getLimitCount();
        this.idCount = performanceStatus.getIdCount();
        this.limitCountMember = performanceStatus.getLimitCountMember();
        this.sysDamai = performanceStatus.getSyncDamai();
        this.isShow = performanceStatus.getIsShow();
        this.isCanRefund = performanceStatus.getIsCanRefund();
        this.isOpenRefundPresent = performanceStatus.getIsOpenRefundPresent();
        this.refundOpenTime = DateUtil.Formatter.yyyyMMddHHmmss.format(performanceStatus.getRefundOpenTime());
        this.refundCloseTime = DateUtil.Formatter.yyyyMMddHHmmss.format(performanceStatus.getRefundCloseTime());
        this.isTransfer = performanceStatus.getIsTransfer();
        this.transferStartTime = DateUtil.Formatter.yyyyMMddHHmmss.format(performanceStatus.getTransferStartTime());
        this.transferEndTime = DateUtil.Formatter.yyyyMMddHHmmss.format(performanceStatus.getTransferEndTime());
        this.isRefundPoundage = performanceStatus.getIsRefundPoundage();
        this.isRefundVoucher = performanceStatus.getIsRefundVoucher();
        this.isRefundExpress = performanceStatus.getIsRefundExpress();
        this.auditStatus = performanceStatus.getAuditStatus();
        this.fieldAuditStatus = performanceStatus.getFieldAuditStatus();
        this.isBackPaperTicket = performanceStatus.getIsBackPaperTicket();
        this.isRefundExpressNew = performanceStatus.getIsRefundExpressNew();
    }

    public void initPerformanceStatusPartner(PerformancePartnerVo performanceStatus) {
        this.statusSell = performanceStatus.getStatusSell();
        this.isRecommend = 0;
        this.isTrueName = performanceStatus.getIsTrueName();
        this.limitCount = performanceStatus.getLimitCount();
        this.idCount = performanceStatus.getIdCount();
        this.limitCountMember = 1;
        this.sysDamai = 0;
        this.isShow = performanceStatus.getIsShow();
        this.isCanRefund = 0;
        this.isOpenRefundPresent = 0;
        this.refundOpenTime = null;
        this.refundCloseTime = null;
        this.isTransfer = 0;
        this.transferStartTime = null;
        this.transferEndTime = null;
        this.isRefundPoundage = 0;
        this.isRefundVoucher = 0;
        this.isRefundExpress = 0;
        this.auditStatus = performanceStatus.getAuditStatus();
        this.fieldAuditStatus = performanceStatus.getFieldAuditStatus();
        this.isBackPaperTicket = 0;
    }

    public void setPerformanceRelations(KylinPerformanceRelations performanceRelations) {
        this.fieldId = performanceRelations.getFieldId();
        this.projectId = performanceRelations.getProjectId();
        this.roadShowId = performanceRelations.getRoadShowId();
        this.merchantId = performanceRelations.getMerchantId();
    }

    public void initPerformanceRelationsPartner(PerformancePartnerVo performanceRelations) {
        this.fieldId = performanceRelations.getFieldId();
        this.projectId = performanceRelations.getProjectId();
        this.roadShowId = performanceRelations.getRoadShowId();
        this.merchantId = performanceRelations.getMerchantId();
    }


    public void setPIsAgent() {
        for (KylinTicketTimesVo timeVo : this.getTicketTimeList()) {
            for (KylinTicketVo ticketVo : timeVo.getTicketList()) {
                if (ticketVo.getIsAgent() == 1) {
                    this.isAgent = 1;
                    break;
                }
            }
        }
    }
}
