package com.liquidnet.service.candy.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import com.liquidnet.service.candy.vo.CandyMyCouponListVo;
import com.liquidnet.service.candy.vo.CandyUseResultVo;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 券基础信息 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
public interface ICandyCouponService extends IService<CandyCoupon> {

    CandyMyCouponListVo myCoupon();

    CandyMyCouponListVo preUsePerformanceCoupon(BigDecimal priceTotal, String performanceId, String timeId, String ticketId);

    Integer preCanUsePerformanceCoupon(BigDecimal priceTotal, String performanceId, String timeId, String ticketId);

    CandyMyCouponListVo preUseGoodCoupon(BigDecimal priceTotal, String goodId, String produceId);

    Integer preCanUseGoodCoupon(BigDecimal priceTotal, String goodId, String produceId);

    List<CandyCouponVo> myAdvanceCoupon();

    Integer stateCoupon(String uCouponId);

    CandyUseResultVo useCoupon( String uCouponId);

    Boolean useBackCoupon(String uCouponId);

    Boolean receiveCoupon(String ccode);
}
