package com.liquidnet.service.platform.controller.adam;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.adam.dto.vo.AdamPosScanitVo;
import com.liquidnet.service.adam.dto.vo.AdamProScanitVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.service.impl.adam.PlatformAdamUserPosService;
import com.liquidnet.service.platform.service.impl.adam.PlatformAdamUserProService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

@Api(tags = "POS机支付:用户相关")
@Slf4j
@Validated
@RestController
@RequestMapping("pos")
public class PlatformAdamPosController {
    @Autowired
    PlatformAdamUserPosService platformAdamUserPosService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "扫一扫")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "code", value = "用户QRCODE"),
    })
    @PutMapping(value = {"scanit"})
    public ResponseDto<AdamPosScanitVo> scanit(@NotBlank(message = "参数有误") @RequestParam String code) {
        return ResponseDto.success(platformAdamUserPosService.scanitProcess(code).desensitize());
    }
}
