package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftTradeDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/29 15:57
 */
@Data
public class GalaxyNftTradeDto implements Serializable,Cloneable {
    /**
     * 应用系统购买系列唯一ID
     */
    private String nftId;
    /**
     * 系列的唯一Id
     */
    private String seriesId;
    /**
     * nftId
     */
    private String tradeHash;
    /**
     * nft价格
     */
    private String chainTimestamp;

    /**
     * 转出方地址
     */
    private String fromAddress;

    /**
     * 转入方地址
     */
    private String toAddress;

    /**
     * nft发行任务ID
     */
    private Long tradePrice;

    /**
     * nft购买任务id(交易类别 1发行 2购买 3转移 4设置价格 5设置状态)
     * @return
     */
    private String tradeType;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;
    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;
    
    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftTradeDto obj = new GalaxyNftTradeDto();

    public static GalaxyNftTradeDto getNew() {
        try {
            return (GalaxyNftTradeDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftTradeDto();
        }
    }
}
