package com.liquidnet.service.stone.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 积分订单表
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class StoneScoreOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * id
     */
    private String orderId;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 用户昵称
     */
    private String userName;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 物品id
     */
    private String itemId;

    /**
     * 物品名称
     */
    private String targetTitle;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 数量
     */
    private Integer number;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 积分
     */
    private BigDecimal score;

    /**
     * 快递价格
     */
    private BigDecimal priceExpress;

    /**
     * 实付价格
     */
    private BigDecimal priceActual;

    /**
     * 选择支付方式[SCORE-积分]
     */
    private String payType;

    /**
     * 实际支付方式[SCORE-积分]
     */
    private String paymentType;

    /**
     * 支付的订单号
     */
    private String paymentId;

    /**
     * 支付时间
     */
    private String timePay;

    /**
     * 订单过期时间(分钟)
     */
    private Integer payCountdownMinute;

    /**
     * 订单状态[0-待付款|1-已付款|2-已关闭|3-正在退款|4-已退款|5-待关闭|6-部分退款]
     */
    private Integer status;

    /**
     * 支付状态[0-未支付|1-已支付|2-支付失败]
     */
    private Integer payStatus;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
