package com.liquidnet.service.adam.service.processor;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.ServletUtils;
import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.entity.AdamThirdParty;
import com.liquidnet.service.adam.mapper.AdamThirdPartyMapper;
import com.liquidnet.service.adam.service.DataMigrationProcessorService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@Service
public class DMThirdPartsProcessor extends DataMigrationProcessorService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    AdamThirdPartyMapper thirdPartyMapper;

    @SneakyThrows
    @Override
    protected void dataProcessing() {
        HttpServletRequest request = ServletUtils.getRequest();
        String flg = StringUtils.defaultIfBlank(request.getParameter(DM_FLG), "");
        if (StringUtils.isNotEmpty(request.getParameter(DM_FLUSH))) {
            log.info("DM.flush.third_party:{}", userMapper.executeForDM("adam_third_party"));

            log.info("DM.flush.AdamThirdPartInfoVo:{}", mongoTemplate.remove(Query.query(Criteria.where("_id").exists(true)), AdamThirdPartInfoVo.class.getSimpleName()).getDeletedCount());
        }

        String sqlCount = "select count(1) from user_third_parts where `status`=1 and delete_tag=0";
        String field = "uid,open_id,avatar,nickname,type,created_at,updated_at";
//                     1-uid,2-open_id,3-avatar,4-nickname,5-type,6-created_at,7-updated_at
        String sql = sqlCount.replace("count(1)", field);

        if ("1".equals(flg)) {
            sqlCount += " and uid in ('2026628','544327','1997335','773650','809406')";
            sql += " and uid in ('2026628','544327','1997335','773650','809406')";
        }

        sql += " limit ?,?";

        statement = connection.prepareStatement(sqlCount);
        row = (ResultSetImpl) statement.executeQuery();
        row.first();
        int ct = row.getInt(1), pSize = 1000, num = 0;
        log.info("DM数据迁移总数:{}", ct);


        while (ct > 0) {
            statement = connection.prepareStatement(sql);
            statement.setInt(1, pSize * num);
            statement.setInt(2, pSize);
            row = (ResultSetImpl) statement.executeQuery();
            log.info("DM.execute.limit:[pNo:{},pSize:{}]", pSize * num, pSize);

            while (row.next()) {
                String uid = row.getString(1);

                if (!reUidList.contains(uid)) {
                    AdamThirdParty thirdParty = new AdamThirdParty();
                    thirdParty.setUid(uid);
                    thirdParty.setOpenId(row.getString(2));
                    thirdParty.setAvatar(row.getString(3));
                    thirdParty.setNickname(row.getString(4));
                    thirdParty.setPlatform(row.getString(5));
                    thirdParty.setState(1);
                    thirdParty.setCreatedAt(row.getLocalDateTime(6));
                    thirdParty.setUpdatedAt(row.getLocalDateTime(7));

                    AdamThirdPartInfoVo vo = AdamThirdPartInfoVo.getNew();
                    vo.setUid(thirdParty.getUid());
                    vo.setOpenId(thirdParty.getOpenId());
                    vo.setNickname(thirdParty.getNickname());
                    vo.setAvatar(thirdParty.getAvatar());
                    vo.setPlatform(thirdParty.getPlatform());
                    vo.setState(thirdParty.getState());
                    vo.setCreatedAt(thirdParty.getCreatedAt());
                    vo.setUpdatedAt(thirdParty.getUpdatedAt());

                    thirdPartyMapper.insert(thirdParty);
                    mongoTemplate.insert(vo, AdamThirdPartInfoVo.class.getSimpleName());
                }
            }


            num++;
            ct -= pSize;
        }
    }
}
