package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class GoblinAppOrderRefundParam {
    @ApiModelProperty(value = "订单id")
    @NotNull(message = "订单ID不能为空")
    private String orderId;
    @ApiModelProperty(value = "退款原因")
    @NotNull(message = "退款原因不能为空")
    private String reason;
    @ApiModelProperty(value = "退款截图[逗号隔开]")
    private String pics;
    @ApiModelProperty(value = "详细描述")
    private String describes;
    @ApiModelProperty(value = "退款类型[1-退款|2-退货]")
    private Integer refundType;
    @ApiModelProperty(value = "退款orderSkuId[不传为整单退款]")
    private String orderSkuId;

    @ApiModelProperty(value = "物流公司")
    private String company;
    @ApiModelProperty(value = "快递单号")
    private String mailNo;
}
