package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "KylinStationCheckOrderVo", description = "下载验票-订单响应参数")
@Data
public class KylinStationCheckOrderVo implements Serializable {
    private static final long serialVersionUID = 7450966265904643147L;
    @ApiModelProperty(position = 10, value = "演出ID[64]")
    private String performanceId;
    @ApiModelProperty(position = 11, value = "订单号")
    private String orderCode;
    @ApiModelProperty(position = 12, value = "二维码地址")
    private String qrCode;
    @ApiModelProperty(position = 13, value = "用户昵称")
    private String userName;
    @ApiModelProperty(position = 14, value = "用户手机号")
    private String userMobile;
    @ApiModelProperty(position = 16, value = "付款张数")
    private Integer number;
    @ApiModelProperty(position = 17, value = "退款张数")
    private Integer refundNumber;
    @ApiModelProperty(position = 18, value = "订单状态:0-待付款,1-已付款,2-已关闭,3-正在退款,4-已退款,5-待关闭,6-部分退款")
    private Integer status;
    @ApiModelProperty(position = 19, value = "支付状态:0-未支付,1-已支付,2-支付失败")
    private Integer payStatus;
    @ApiModelProperty(position = 20, value = "是否学生票[1-是,2-否]")
    private Integer isStudent;
    @ApiModelProperty(position = 21, value = "购买者是否是会员[0-否,1-是]")
    private Integer isMember;

    @ApiModelProperty(position = 30, value = "*验票张数")
    private Integer checkedNumber;
    @ApiModelProperty(position = 31, value = "*是否已同步[0-否,1-是]")
    private Integer synced;

    private static final KylinStationCheckOrderVo obj = new KylinStationCheckOrderVo();

    public static KylinStationCheckOrderVo getNew() {
        try {
            return (KylinStationCheckOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinStationCheckOrderVo();
        }
    }
}
