package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;

@ApiModel(value = "GoblinStoreMgtGoodsFilterParam", description = "商品管理:商品列表筛选条件")
@Data
public class GoblinStoreMgtGoodsSkuFilterParam implements Serializable {
    private static final long serialVersionUID = -4698854628491039006L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 21, required = true, value = "SpuId")
    @NotBlank(message = "SPUID不能为空")
    private String spuId;
    @ApiModelProperty(position = 11, required = true, value = "当前记录起始索引", example = "1")
    @Min(value = 1, message = "起始索引无效")
    @NotNull(message = "起始索引无效")
    private Integer pageNum;
    @ApiModelProperty(position = 13, required = false, value = "搜索关键字[128]")
    private String keyword;
    @ApiModelProperty(position = 14, required = false, value = "商品上架状态[0-待上架|1-下架|2-违规|3-上架]", allowableValues = "0,1,2,3")
    private String shelvesStatus;

}
