package com.liquidnet.service.adam.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.SqlMapping;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.mapper.AdamMemberMapper;
import com.liquidnet.service.adam.service.IAdamMemberService;
import com.mongodb.BasicDBObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class AdamMemberServiceImpl extends ServiceImpl<AdamMemberMapper, AdamMember> implements IAdamMemberService {

    @Autowired
    AdamMemberMapper adamMemberMapper;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public List<AdamMember> list() {
        List<AdamMember> infoList = new ArrayList<>();
        List<Object> list = redisUtil.lGet(AdamRedisConst.INFO_MEMBERS, 0, -1);

        if (CollectionUtils.isEmpty(list)) {
            infoList = mongoTemplate.findAll(AdamMember.class);
        } else {
            for (Object o : list) {
                infoList.add((AdamMember) o);
            }
        }
        return infoList;
    }

    @Override
    public void add(AdamMember info) {
        // 添加数据到 Mongo
        mongoTemplate.insert(Collections.singletonList(info), AdamMember.class.getSimpleName());
        List<Object> paramList = new ArrayList<>();
        paramList.add(info.getName());
        paramList.add(info.getTitle());
        paramList.add(info.getSubTitle());
        paramList.add(info.getIcon());
        paramList.add(info.getAvatar());
        paramList.add(info.getStartNo());
        paramList.add(info.getType());
        paramList.add(info.getInterestsDetail());
        paramList.add(info.getNotes());
        paramList.add(info.getIsNotice());
        paramList.add(info.getNoticeInfo());
        paramList.add(info.getNoticeTitle());
        paramList.add(info.getNeedQuestion());
        paramList.add(info.getDisplayAgreement());
        paramList.add(info.getAgreement());
        paramList.add(info.getMemberId());
        paramList.add(info.getLimitation());
        // todo 放入MQ
//        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
//                SqlMapping.get("adam_member.add", paramList.toArray()));
        // todo 同步redis
        redisUtil.lSet(AdamRedisConst.INFO_MEMBERS, info);
        redisUtil.hset(AdamRedisConst.INFO_MEMBERS_INFO.concat(info.getMemberId()), info.getMemberId(), info);
    }

    @Override
    public AdamMember query(String memberId) {
        AdamMember info = null;
        info = (AdamMember) redisUtil.hget(AdamRedisConst.INFO_MEMBERS_INFO.concat(memberId), memberId);
        if (null == info) {
            info = mongoTemplate.findOne(Query.query(Criteria.where("memberId").is(memberId)), AdamMember.class, AdamMember.class.getSimpleName());
        }
        return info;
    }

    @Override
    public void edit(AdamMember info) {
        BasicDBObject object = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(info)));

        mongoTemplate.getCollection(AdamMember.class.getSimpleName())
                .updateOne(Query.query(Criteria.where("mId").is(info.getMid())).getQueryObject(), object);

        // todo 放入MQ
        redisUtil.hset(AdamRedisConst.INFO_MEMBERS_INFO.concat(info.getMid().toString()), info.getMid().toString(), info);
        redisUtil.lRemove(AdamRedisConst.INFO_MEMBERS, 1, info);
        redisUtil.lSet(AdamRedisConst.INFO_MEMBERS, info);
    }
}
