package com.liquidnet.service.kylin.service.impl.partner;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dao.PerformancePartnerListDao;
import com.liquidnet.service.kylin.dto.TicketInventoryDto;
import com.liquidnet.service.kylin.dto.param.PerformanceCreateParam;
import com.liquidnet.service.kylin.dto.param.PerformanceListParam;
import com.liquidnet.service.kylin.dto.param.PerformanceStep1Param;
import com.liquidnet.service.kylin.dto.param.PerformanceStep2Param;
import com.liquidnet.service.kylin.dto.vo.FieldsVo;
import com.liquidnet.service.kylin.dto.vo.PerformanceVo;
import com.liquidnet.service.kylin.dto.vo.TicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.TicketVo;
import com.liquidnet.service.kylin.dto.vo.ignore.PerformanceIgnoreVo;
import com.liquidnet.service.kylin.dto.vo.ignore.TicketIgnoreVo;
import com.liquidnet.service.kylin.dto.vo.ignore.TicketTimesIgnoreVo;
import com.liquidnet.service.kylin.dto.vo.partner.*;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.partner.IKylinPerformancesPartnerService;
import com.liquidnet.service.kylin.timerTask.PerformanceVoTask;
import com.mongodb.BasicDBObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Service
public class KylinPerformancesPartnerServiceImpl extends ServiceImpl<KylinPerformancesMapper, KylinPerformances> implements IKylinPerformancesPartnerService {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private PerformanceVoTask performanceVoTask;

    @Autowired
    private KylinPerformancesMapper performancesMapper;

    @Autowired
    private KylinPerformanceStatusMapper performanceStatusMapper;

    @Autowired
    private KylinPerformanceRelationsMapper performanceRelationsMapper;

    @Autowired
    private KylinTicketTimesMapper ticketTimesMapper;

    @Autowired
    private KylinTicketTimeRelationMapper ticketTimeRelationMapper;

    @Autowired
    private KylinTicketsMapper ticketsMapper;

    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;

    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;

    @Autowired
    private KylinTicketsPartnerServiceImpl ticketsPartnerService;

    @Autowired
    private KylinTicketTimesPartnerServiceImpl ticketTimesPartnerService;

    @Override
    public String createStep1(PerformanceStep1Param step1Param) {
        // 获取 主键id
        String performanceId = IDGenerator.nextSnowId().toString();
        // 获取 当前时间 -> 创建时间
        LocalDateTime createdAt = LocalDateTime.now();

        try {
            step1Param.setCreatedAt(createdAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            step1Param.setPerformancesId(performanceId);
            PerformanceCreateParam performanceCreateParam = new PerformanceCreateParam();
            BeanUtils.copyProperties(step1Param, performanceCreateParam);
            performanceCreateParam.setIsTrueName(0);
            performanceCreateParam.setLimitCount(0);
            performanceCreateParam.setCreatedAt(createdAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            performanceCreateParam.setIsSubmit(0);
            performanceCreateParam.setStatus(0);
            performanceCreateParam.setStatusSell(1);
            mongoTemplate.insert(
                    performanceCreateParam, PerformanceCreateParam.class.getSimpleName()
            );

            return performanceId;
        } catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean createStep2(PerformanceStep2Param step2Param) {

        // 获取 主键id
        String performanceId = step2Param.getPerformancesId();
        // 获取 当前时间 -> 创建时间
        LocalDateTime createdAt = LocalDateTime.now();

        boolean isExistsSubmit = mongoTemplate.exists(Query.query(Criteria.where("performancesId").is(performanceId).and("status").is(1)),
                PerformanceCreateParam.class,
                PerformanceCreateParam.class.getSimpleName());

        if (isExistsSubmit) {
            return false;
        }

        //演出修改数据
        HashMap<String, Object> map = new HashMap<>();
        map.put("isTrueName", step2Param.getIsTrueName());
        map.put("limitCount", step2Param.getLimitCount());
        map.put("createdAt", createdAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        map.put("isSubmit", step2Param.getIsSubmit());
        map.put("statusSell", 1);

        // 获取第一步数据
        if (step2Param.getIsSubmit() == 1) { // 提交
            map.put("status", 1);
            BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
            mongoTemplate.getCollection(PerformanceCreateParam.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("performancesId").is(performanceId)).getQueryObject(),
                    object
            );
            //提交 票
            List<TicketTimesCreatePartnerVo> ticketTimesCreatePartnerVoList = ticketTimesPartnerService.getTimesMongoList(performanceId);
            for (TicketTimesCreatePartnerVo ticketTimes : ticketTimesCreatePartnerVoList) {
                boolean boolResult = ticketsPartnerService.submitTicketByTimes(ticketTimes.getTicketTimesId());
                if (boolResult) {
                    return false;
                }
            }
            if (ticketTimesCreatePartnerVoList.size() <= 0) {
                return false;
            } else {
                PerformanceCreatePartnerVo performanceCreatePartnerVo = performanceVoTask.createPerformanceCreateParam(performanceId);

                HashMap<String, Object> mapSql = new HashMap<>();
                mapSql.put("rejectTxt", "");
                mapSql.put("status", 1);
                mapSql.put("updatedAt", createdAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                performanceVoTask.createPerformanceMySql(performanceId, mapSql, performanceCreatePartnerVo, createdAt);
            }
        } else { //保存
            map.put("status", 0);
            BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
            mongoTemplate.getCollection(PerformanceCreateParam.class.getSimpleName()).updateMany(
                    Query.query(Criteria.where("performancesId").is(performanceId)).getQueryObject(),
                    object
            );
        }

        return true;
    }

    @Override
    public PerformanceCreateParam getStep1(String performancesId) {
        PerformanceCreateParam data = mongoTemplate.findOne(
                Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceCreateParam.class, PerformanceCreateParam.class.getSimpleName()
        );
        if (data == null) {
            return new PerformanceCreateParam();
        }
        return data;
    }

    @Override
    public PerformanceStep2Param getStep2(String performancesId) {
        PerformanceCreateParam data = mongoTemplate.findOne(
                Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceCreateParam.class, PerformanceCreateParam.class.getSimpleName()
        );

        if (data == null) {
            return new PerformanceStep2Param();
        }

        List<TicketTimesCreatePartnerVo> ticketTimesCreatePartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
        List<TicketTimesTicketCreatePartnerVo> ticketTimesTicketCreatePartnerVoList = new ArrayList<TicketTimesTicketCreatePartnerVo>();

        for (TicketTimesCreatePartnerVo ticketTimes : ticketTimesCreatePartnerVos) {
            TicketTimesTicketCreatePartnerVo ticketTimesTicketCreatePartnerVo = new TicketTimesTicketCreatePartnerVo();
            BeanUtils.copyProperties(ticketTimes, ticketTimesTicketCreatePartnerVo);
            List<TicketCreatePartnerVo> ticketCreatePartnerVos = ticketsPartnerService.getTicketMongoList(ticketTimes.getTicketTimesId());
            ticketTimesTicketCreatePartnerVo.setTicket(ticketCreatePartnerVos);
            ticketTimesTicketCreatePartnerVoList.add(ticketTimesTicketCreatePartnerVo);
        }

        PerformanceStep2Param performanceStep2Param = new PerformanceStep2Param();
        BeanUtils.copyProperties(data, performanceStep2Param);
        performanceStep2Param.setTicketTimes(ticketTimesTicketCreatePartnerVoList);

        return performanceStep2Param;
    }

    @Override
    public boolean onLinePerformance(String performancesId) {
        try {
            KylinPerformanceStatus performanceStatusData = performanceStatusMapper.selectOne(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
            if (!(performanceStatusData.getStatus() == 3 || performanceStatusData.getStatus() == 7)) {
                return false;
            }
            // mysql
            LocalDateTime updatedAt = LocalDateTime.now();
            KylinPerformanceStatus performanceStatusUpdate = new KylinPerformanceStatus();
            performanceStatusUpdate.setStatus(6);
            performanceStatusUpdate.setUpdatedAt(updatedAt);
            performanceStatusMapper.update(performanceStatusUpdate
                    , new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));

            //mongo操作 票
            KylinPerformanceRelations performanceRelationsData = performanceRelationsMapper.selectOne(new UpdateWrapper<KylinPerformanceRelations>().eq("performance_id", performancesId));
            KylinPerformances performancesData = performancesMapper.selectOne(new UpdateWrapper<KylinPerformances>().eq("performances_id", performancesId));
            PerformanceVo performanceVoData = new PerformanceVo();
            performanceVoData.setPerformance(performancesData);
            performanceVoData.setPerformanceRelations(performanceRelationsData);
            performanceVoData.setPerformanceStatus(performanceStatusData);

            //场次
            List<KylinTicketTimeRelation> ticketTimeRelation = ticketTimeRelationMapper.selectList(
                    new UpdateWrapper<KylinTicketTimeRelation>().eq("performance_id", performancesId)
            );

            LocalDateTime stopSellTime = null;
            LocalDateTime sellTime = null;
            int isLackRegister = 0;
            int isMember = 0;
            int isExclusive = 0;
            BigDecimal price = new BigDecimal("0.00");


            for (KylinTicketTimeRelation ticketTimeRelationItem : ticketTimeRelation) {
                KylinTicketTimes ticketTimes = ticketTimesMapper.selectOne(new UpdateWrapper<KylinTicketTimes>().eq("ticket_times_id", ticketTimeRelationItem.getTimesId()).eq("status", 1));
                TicketTimesVo ticketTimesVo = new TicketTimesVo();
                ticketTimesVo.setTicketTimes(ticketTimes);
                ticketTimesVo.setPerformanceId(ticketTimeRelationItem.getPerformanceId());
                ticketTimesVo.setTimeId(ticketTimeRelationItem.getTimesId());
                //票
                List<KylinTicketRelations> ticketRelations = ticketRelationsMapper.selectList(new UpdateWrapper<KylinTicketRelations>().eq("times_id", ticketTimes.getTicketTimesId()));
                for (KylinTicketRelations ticketRelationsItem : ticketRelations) {
                    KylinTicketStatus ticketStatus = ticketStatusMapper.selectOne(new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", ticketRelationsItem.getTicketId()).between("status", 6, 10).ne("status", 7));
                    KylinTickets tickets = ticketsMapper.selectOne(
                            new UpdateWrapper<KylinTickets>().eq("tickets_id", ticketStatus.getTicketId()
                            )
                    );
                    KylinTicketStatus ticketStatusUpdate = new KylinTicketStatus();
                    ticketStatusUpdate.setStatus(9);
                    ticketStatusUpdate.setUpdatedAt(updatedAt);
                    ticketStatusMapper.update(ticketStatusUpdate
                            , new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", ticketStatus.getTicketId()).eq("status", 7));
                    TicketVo ticketVo = new TicketVo();
                    ticketVo.setTimeId(ticketRelationsItem.getTimesId());
                    ticketVo.setTicket(tickets);
                    ticketVo.setTicketStatus(ticketStatus);
                    mongoTemplate.insert(
                            ticketVo, TicketVo.class.getSimpleName()
                    );
                    //票种 库存redis TODO 库存可能会丢
                    TicketInventoryDto ticketInventoryRedis = (TicketInventoryDto) redisUtil.hget(KylinRedisConst.PERFORMANCES_INVENTORY, ticketVo.getTicketsId());
                    TicketInventoryDto ticketInventoryDto = new TicketInventoryDto();
                    if (ticketInventoryRedis == null) {
                        ticketInventoryDto.setSurplusExchange(ticketStatus.getSurplusExchange());
                        ticketInventoryDto.setSurplusGeneral(ticketStatus.getTotalGeneral());
                        ticketInventoryDto.setTicketsId(ticketVo.getTicketsId());
                    } else {
                        ticketInventoryDto.setSurplusExchange(ticketStatus.getSurplusExchange() - ticketInventoryRedis.getSurplusExchange());
                        ticketInventoryDto.setSurplusGeneral(ticketStatus.getTotalGeneral() - ticketInventoryRedis.getSurplusGeneral());
                        ticketInventoryDto.setTicketsId(ticketVo.getTicketsId());
                    }
                    redisUtil.hset(KylinRedisConst.PERFORMANCES_INVENTORY, ticketVo.getTicketsId(), ticketInventoryDto);

                    if (ticketVo.getIsMember() == 1) {
                        isMember = 1;
                    }
                    if (ticketVo.getIsLackRegister() == 1) {
                        isLackRegister = 1;
                    }
                    if (ticketVo.getIsExclusive() == 1) {
                        isExclusive = 1;
                    }
                    if (price.subtract(ticketVo.getPrice()).compareTo(new BigDecimal("0.00")) < 0) {
                        price = ticketVo.getPrice();
                    }
                    if (stopSellTime == null || stopSellTime.isBefore(tickets.getTimeEnd())) {
                        stopSellTime = tickets.getTimeEnd();
                    }
                    if (sellTime == null || sellTime.isAfter(tickets.getTimeStart().plusMinutes(-tickets.getAdvanceMinuteMember()))) {
                        sellTime = tickets.getTimeStart().plusMinutes(-tickets.getAdvanceMinuteMember());
                    }
                }
                mongoTemplate.insert(
                        ticketTimesVo, TicketTimesVo.class.getSimpleName()
                );
            }
            performanceVoData.setTimePriceVipAndLack(isLackRegister, isMember, isExclusive, price, stopSellTime, sellTime);
            mongoTemplate.insert(
                    performanceVoData, PerformanceVo.class.getSimpleName()
            );
            //修改 提审vo
            Map<String, Object> map = new HashMap<>();
            map.put("status", 3);
            BasicDBObject objectPerformance = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
            mongoTemplate.getCollection(PerformanceCreatePartnerVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                    objectPerformance
            );
            //判断状态
            performanceVoTask.performanceVoStatus(performancesId);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean outLinePerformance(String performancesId) {
        try {

            KylinPerformanceStatus performanceStatusData = performanceStatusMapper.selectOne(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));

            if (performanceStatusData.getStatus() != 6) {
                return false;
            }

            LocalDateTime updatedAt = LocalDateTime.now();
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            performanceStatus.setStatus(7);
            performanceStatus.setUpdatedAt(updatedAt);
            performanceStatusMapper.update(performanceStatus
                    , new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));

            //mongoVo 迁移 演出数据迁移
            PerformanceVo performanceVo = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceVo.class, PerformanceVo.class.getSimpleName());
            PerformanceIgnoreVo performanceIgnoreVo = new PerformanceIgnoreVo();
            BeanUtils.copyProperties(performanceVo, performanceIgnoreVo);
            performanceIgnoreVo.setAppStatus(7);
            mongoTemplate.remove(Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceIgnoreVo.class, PerformanceIgnoreVo.class.getSimpleName());
            mongoTemplate.insert(performanceIgnoreVo, PerformanceIgnoreVo.class.getSimpleName());
            mongoTemplate.remove(Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceVo.class, PerformanceVo.class.getSimpleName());

            List<TicketTimesVo> ticketTimesVoList = mongoTemplate.find(Query.query(Criteria.where("performanceId").is(performancesId)), TicketTimesVo.class, TicketTimesVo.class.getSimpleName());
            for (TicketTimesVo ticketTimesVoItem : ticketTimesVoList) {
                //场次数据迁移
                TicketTimesIgnoreVo ticketTimesIgnoreVo = new TicketTimesIgnoreVo();
                BeanUtils.copyProperties(ticketTimesVoItem, ticketTimesIgnoreVo);
                mongoTemplate.remove(Query.query(Criteria.where("ticketTimesId").is(ticketTimesVoItem.getTicketTimesId())), TicketTimesIgnoreVo.class, TicketTimesIgnoreVo.class.getSimpleName());
                mongoTemplate.insert(ticketTimesIgnoreVo, TicketTimesIgnoreVo.class.getSimpleName());
                mongoTemplate.remove(Query.query(Criteria.where("ticketTimesId").is(ticketTimesVoItem.getTicketTimesId())), TicketTimesVo.class, TicketTimesVo.class.getSimpleName());

                List<TicketVo> ticketVoList = mongoTemplate.find(Query.query(Criteria.where("timeId").is(ticketTimesVoItem.getTicketTimesId())), TicketVo.class, TicketVo.class.getSimpleName());
                for (TicketVo ticketVoItem : ticketVoList) {
                    // 票 迁移
                    TicketIgnoreVo ticketIgnoreVo = new TicketIgnoreVo();
                    BeanUtils.copyProperties(ticketVoItem, ticketIgnoreVo);
                    mongoTemplate.remove(Query.query(Criteria.where("ticketsId").is(ticketVoItem.getTicketsId())), TicketIgnoreVo.class, TicketIgnoreVo.class.getSimpleName());
                    mongoTemplate.insert(ticketIgnoreVo, TicketIgnoreVo.class.getSimpleName());
                    mongoTemplate.remove(Query.query(Criteria.where("ticketsId").is(ticketVoItem.getTicketsId())), TicketVo.class, TicketVo.class.getSimpleName());
                }
            }
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public PageInfo<PerformancePartnerListDao> getList(PerformanceListParam performanceListParam) {
        HashMap<String, Object> info = new HashMap<>();
        int status = performanceListParam.getStatus();
        int page = performanceListParam.getPage() - 1;
        int size = performanceListParam.getSize();
        PageInfo<PerformancePartnerListDao> pageInfoTmp = null;
        if (status == 0) {//未发布演出
            // 排序 分页
            Pageable pageable = PageRequest.of(page, size, Sort.by(Sort.Direction.DESC, "createdAt"));
            //条件
            Criteria criteria = Criteria.where("status").is(status);
            if (!performanceListParam.getTitle().isEmpty()) {
                criteria.and("title").regex(".*?\\" + performanceListParam.getTitle());
            }
            Query query = Query.query(criteria);
            // 查询总数
            long count = mongoTemplate.count(query, PerformanceCreateParam.class, PerformanceCreateParam.class.getSimpleName());
            List<PerformanceCreateParam> performanceCreateParam = mongoTemplate.find(query, PerformanceCreateParam.class, PerformanceCreateParam.class.getSimpleName());
            query.with(pageable);
            //处理Vo
            List<PerformancePartnerListVo> voList = new ArrayList<>();
            for (PerformanceCreateParam item : performanceCreateParam) {
                PerformancePartnerListVo voData = new PerformancePartnerListVo();
                voData.setStatus0Data(item);
                voList.add(voData);
            }
            pageInfoTmp = new PageInfo(voList);
            pageInfoTmp.setTotal(count);
        } else {//演出列表
            try {
                PageHelper.startPage(performanceListParam.getPage(), performanceListParam.getSize());
                List<PerformancePartnerListDao> voList = performancesMapper.partnerPerformanceList(BeanUtil.convertBeanToMap(performanceListParam));
                pageInfoTmp = new PageInfo(voList);
                return pageInfoTmp;
            } catch (Exception e) {
                return null;
            }
        }
        return pageInfoTmp;
    }
}
